package xyz.mcxross.ksui.generated

import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.inputs.CheckpointId
import xyz.mcxross.ksui.generated.paginatecheckpointtransactionblocks.Checkpoint

public const val PAGINATE_CHECKPOINT_TRANSACTION_BLOCKS: String =
    "query paginateCheckpointTransactionBlocks(${'$'}id: CheckpointId, ${'$'}after: String) {\n    checkpoint(id: ${'$'}id) {\n        transactionBlocks(after: ${'$'}after) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                digest\n            }\n        }\n    }\n}"

@Generated
@Serializable
public class PaginateCheckpointTransactionBlocks(
  override val variables: PaginateCheckpointTransactionBlocks.Variables,
) : GraphQLClientRequest<PaginateCheckpointTransactionBlocks.Result>() {
  @Required
  override val query: String = PAGINATE_CHECKPOINT_TRANSACTION_BLOCKS

  @Required
  override val operationName: String? = "paginateCheckpointTransactionBlocks"

  @Generated
  @Serializable
  public data class Variables(
    public val id: CheckpointId? = null,
    public val after: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Fetch checkpoint information by sequence number or digest (defaults to the latest available
     * checkpoint).
     */
    public val checkpoint: Checkpoint? = null,
  )
}
