package xyz.mcxross.ksui.generated

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.paginateepochvalidators.Epoch

public const val PAGINATE_EPOCH_VALIDATORS: String =
    "query paginateEpochValidators(${'$'}id: Int!, ${'$'}after: String) {\n    epoch(id: ${'$'}id) {\n        validatorSet {\n            activeValidators(after: ${'$'}after) {\n                pageInfo {\n                    hasNextPage\n                    endCursor\n                }\n                nodes {\n                    ...RPC_VALIDATOR_FIELDS\n                }\n            }\n        }\n    }\n}\n\nfragment RPC_VALIDATOR_FIELDS on Validator {\n    atRisk\n    commissionRate\n    exchangeRatesSize\n    description\n    gasPrice\n    imageUrl\n    name\n    credentials {\n        ...RPC_CREDENTIAL_FIELDS\n    }\n    nextEpochCommissionRate\n    nextEpochGasPrice\n    nextEpochCredentials {\n        ...RPC_CREDENTIAL_FIELDS\n    }\n    nextEpochStake\n    operationCap {\n        address\n    }\n    pendingPoolTokenWithdraw\n    pendingStake\n    pendingTotalSuiWithdraw\n    poolTokenBalance\n    projectUrl\n    rewardsPool\n    stakingPoolActivationEpoch\n    stakingPoolSuiBalance\n    address {\n        address\n    }\n    votingPower\n}\n\nfragment RPC_CREDENTIAL_FIELDS on ValidatorCredentials {\n    netAddress\n    networkPubKey\n    p2PAddress\n    primaryAddress\n    workerPubKey\n    workerAddress\n    proofOfPossession\n    protocolPubKey\n}"

@Generated
@Serializable
public class PaginateEpochValidators(
  override val variables: PaginateEpochValidators.Variables,
) : GraphQLClientRequest<PaginateEpochValidators.Result>() {
  @Required
  override val query: String = PAGINATE_EPOCH_VALIDATORS

  @Required
  override val operationName: String? = "paginateEpochValidators"

  @Generated
  @Serializable
  public data class Variables(
    public val id: Int,
    public val after: String? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Fetch epoch information by ID (defaults to the latest epoch).
     */
    public val epoch: Epoch? = null,
  )
}
