package xyz.mcxross.ksui.generated

import kotlin.Boolean
import kotlin.String
import kotlinx.serialization.Required
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.graphql.client.types.GraphQLClientRequest
import xyz.mcxross.ksui.generated.gettransactionblock.TransactionBlock

public const val GET_TRANSACTION_BLOCK: String =
    "query getTransactionBlock(\n    ${'$'}digest: String!\n    ${'$'}showBalanceChanges: Boolean = false\n    ${'$'}showEffects: Boolean = false\n    ${'$'}showRawEffects: Boolean = false\n    ${'$'}showEvents: Boolean = false\n    ${'$'}showInput: Boolean = false\n    ${'$'}showObjectChanges: Boolean = false\n    ${'$'}showRawInput: Boolean = false\n) {\n    transactionBlock(digest: ${'$'}digest) {\n        ...RPC_TRANSACTION_FIELDS\n    }\n}\n\nfragment RPC_TRANSACTION_FIELDS on TransactionBlock {\n    digest\n    rawTransaction: bcs @include(if: ${'$'}showRawInput)\n    sender {\n        address\n    }\n\n    signatures\n\n    effects {\n        bcs @include(if: ${'$'}showRawEffects)\n        events @include(if: ${'$'}showEvents) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                ...RPC_EVENTS_FIELDS\n            }\n        }\n        checkpoint {\n            sequenceNumber\n        }\n        timestamp\n        balanceChanges @include(if: ${'$'}showBalanceChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                coinType {\n                    repr\n                }\n                owner {\n                    asObject {\n                        address\n                    }\n                    asAddress {\n                        address\n                    }\n                }\n                amount\n            }\n        }\n\n        objectChanges @include(if: ${'$'}showObjectChanges) {\n            pageInfo {\n                hasNextPage\n                endCursor\n            }\n            nodes {\n                address\n                inputState {\n                    version\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                }\n                outputState {\n                    asMoveObject {\n                        contents {\n                            type {\n                                repr\n                            }\n                        }\n                    }\n                    asMovePackage {\n                        modules(first: 10) {\n                            nodes {\n                                name\n                            }\n                        }\n                    }\n                }\n            }\n        }\n    }\n}\n\nfragment RPC_EVENTS_FIELDS on Event {\n    sendingModule {\n        package {\n            address\n        }\n        name\n    }\n    sender {\n        address\n    }\n    type {\n        repr\n    }\n    json\n    bcs\n    timestamp\n}"

@Generated
@Serializable
public class GetTransactionBlock(
  override val variables: GetTransactionBlock.Variables,
) : GraphQLClientRequest<GetTransactionBlock.Result>() {
  @Required
  override val query: String = GET_TRANSACTION_BLOCK

  @Required
  override val operationName: String? = "getTransactionBlock"

  @Generated
  @Serializable
  public data class Variables(
    public val digest: String,
    public val showBalanceChanges: Boolean? = null,
    public val showEffects: Boolean? = null,
    public val showRawEffects: Boolean? = null,
    public val showEvents: Boolean? = null,
    public val showInput: Boolean? = null,
    public val showObjectChanges: Boolean? = null,
    public val showRawInput: Boolean? = null,
  )

  @Generated
  @Serializable
  public data class Result(
    /**
     * Fetch a transaction block by its transaction digest.
     */
    public val transactionBlock: TransactionBlock? = null,
  )
}
