package xyz.mcxross.ksui.generated.getcheckpoints

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.Base64
import xyz.mcxross.ksui.generated.DateTime

/**
 * Checkpoints contain finalized transactions and are used for node synchronization
 * and global transaction ordering.
 */
@Generated
@Serializable
public data class Checkpoint(
  /**
   * A 32-byte hash that uniquely identifies the checkpoint contents, encoded in Base58. This
   * hash can be used to verify checkpoint contents by checking signatures against the committee,
   * Hashing contents to match digest, and checking that the previous checkpoint digest matches.
   */
  public val digest: String,
  /**
   * The epoch this checkpoint is part of.
   */
  public val epoch: Epoch?,
  /**
   * The computation cost, storage cost, storage rebate, and non-refundable storage fee
   * accumulated during this epoch, up to and including this checkpoint. These values increase
   * monotonically across checkpoints in the same epoch, and reset on epoch boundaries.
   */
  public val rollingGasSummary: GasCostSummary?,
  /**
   * The total number of transaction blocks in the network by the end of this checkpoint.
   */
  public val networkTotalTransactions: Int?,
  /**
   * The digest of the checkpoint at the previous sequence number.
   */
  public val previousCheckpointDigest: String?,
  /**
   * This checkpoint's position in the total order of finalized checkpoints, agreed upon by
   * consensus.
   */
  public val sequenceNumber: Int,
  /**
   * The timestamp at which the checkpoint is agreed to have happened according to consensus.
   * Transactions that access time in this checkpoint will observe this timestamp.
   */
  public val timestamp: DateTime,
  /**
   * This is an aggregation of signatures from a quorum of validators for the checkpoint
   * proposal.
   */
  public val validatorSignatures: Base64,
  /**
   * Transactions in this checkpoint.
   */
  public val transactionBlocks: TransactionBlockConnection,
  /**
   * Transactions in this checkpoint.
   */
  public val endOfEpoch: TransactionBlockConnection2,
)
