package xyz.mcxross.ksui.generated.getcheckpoints

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated

/**
 * The kind of transaction block, either a programmable transaction or a system transaction.
 */
@Generated
@Serializable
public sealed class TransactionBlockKind

/**
 * System transaction that supersedes `ChangeEpochTransaction` as the new way to run transactions
 * at the end of an epoch. Behaves similarly to `ChangeEpochTransaction` but can accommodate other
 * optional transactions to run at the end of the epoch.
 */
@Generated
@Serializable
@SerialName(value = "EndOfEpochTransaction")
public data class EndOfEpochTransaction(
  /**
   * The list of system transactions that are allowed to run at the end of the epoch.
   */
  public val transactions: EndOfEpochTransactionKindConnection,
) : TransactionBlockKind()

/**
 * Fallback TransactionBlockKind implementation that will be used when unknown/unhandled type is
 * encountered.
 *
 * NOTE: This fallback logic has to be manually registered with the instance of
 * GraphQLClientKotlinxSerializer. See documentation for details.
 */
@Generated
@Serializable
public class DefaultTransactionBlockKindImplementation() : TransactionBlockKind()
