package xyz.mcxross.ksui.generated.getdynamicfieldobject

import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt
import xyz.mcxross.ksui.generated.SuiAddress

/**
 * An object in Sui is a package (set of Move bytecode modules) or object (typed data structure
 * with fields) with additional metadata detailing its id, version, transaction digest, owner
 * field indicating how this object can be accessed.
 */
@Generated
@Serializable
public data class Object(
  public val address: SuiAddress,
  /**
   * 32-byte hash that identifies the object's current contents, encoded as a Base58 string.
   */
  public val digest: String? = null,
  public val version: Int,
  /**
   * The amount of SUI we would rebate if this object gets deleted or mutated. This number is
   * recalculated based on the present storage gas price.
   */
  public val storageRebate: BigInt? = null,
  /**
   * The owner type of this object: Immutable, Shared, Parent, Address
   * Immutable and Shared Objects do not have owners.
   */
  public val owner: ObjectOwner2? = null,
  /**
   * The transaction block that created this version of the object.
   */
  public val previousTransactionBlock: TransactionBlock? = null,
  /**
   * Attempts to convert the object into a MoveObject
   */
  public val asMoveObject: MoveObject2? = null,
)
