package xyz.mcxross.ksui.generated.getlatestsuisystemstate

import kotlin.Int
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.BigInt

/**
 * Details of the system that are decided during genesis.
 */
@Generated
@Serializable
public data class SystemParameters(
  /**
   * The minimum number of active validators that the system supports.
   */
  public val minValidatorCount: Int? = null,
  /**
   * The maximum number of active validators that the system supports.
   */
  public val maxValidatorCount: Int? = null,
  /**
   * Minimum stake needed to become a new validator.
   */
  public val minValidatorJoiningStake: BigInt? = null,
  /**
   * Target duration of an epoch, in milliseconds.
   */
  public val durationMs: BigInt? = null,
  /**
   * Validators with stake below this threshold will enter the grace period (see
   * `validatorLowStakeGracePeriod`), after which they are removed from the active validator set.
   */
  public val validatorLowStakeThreshold: BigInt? = null,
  /**
   * The number of epochs that a validator has to recover from having less than
   * `validatorLowStakeThreshold` stake.
   */
  public val validatorLowStakeGracePeriod: BigInt? = null,
  /**
   * Validators with stake below this threshold will be removed from the active validator set
   * at the next epoch boundary, without a grace period.
   */
  public val validatorVeryLowStakeThreshold: BigInt? = null,
  /**
   * The epoch at which stake subsidies start being paid out.
   */
  public val stakeSubsidyStartEpoch: Int? = null,
)
