package xyz.mcxross.ksui.generated.getownedobjects

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.Base64
import xyz.mcxross.ksui.generated.BigInt
import xyz.mcxross.ksui.generated.SuiAddress

/**
 * The representation of an object as a Move Object, which exposes additional information
 * (content, module that governs it, version, is transferrable, etc.) about this object.
 */
@Generated
@Serializable
public data class MoveObject(
  public val objectId: SuiAddress,
  /**
   * The Base64-encoded BCS serialization of the object's content.
   */
  public val bcs: Base64?,
  /**
   * Determines whether a transaction can transfer this object, using the TransferObjects
   * transaction command or `sui::transfer::public_transfer`, both of which require the object to
   * have the `key` and `store` abilities.
   */
  public val hasPublicTransfer: Boolean?,
  /**
   * Displays the contents of the Move object in a JSON string and through GraphQL types. Also
   * provides the flat representation of the type signature, and the BCS of the corresponding
   * data.
   */
  public val contents: MoveValue?,
  /**
   * The owner type of this object: Immutable, Shared, Parent, Address
   */
  public val owner: ObjectOwner?,
  /**
   * The transaction block that created this version of the object.
   */
  public val previousTransactionBlock: TransactionBlock?,
  /**
   * The amount of SUI we would rebate if this object gets deleted or mutated. This number is
   * recalculated based on the present storage gas price.
   */
  public val storageRebate: BigInt?,
  /**
   * 32-byte hash that identifies the object's contents, encoded as a Base58 string.
   */
  public val digest: String?,
  public val version: Int,
  /**
   * The set of named templates defined on-chain for the type of this object, to be handled
   * off-chain. The server substitutes data from the object into these templates to generate a
   * display string per template.
   */
  public val display: List<DisplayEntry>?,
)
