package xyz.mcxross.ksui.generated.inputs

import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.SuiAddress

/**
 * Constrains the set of objects returned. All filters are optional, and the resulting set of
 * objects are ones whose
 *
 * - Type matches the `type` filter,
 * - AND, whose owner matches the `owner` filter,
 * - AND, whose ID is in `objectIds` OR whose ID and version is in `objectKeys`.
 */
@Generated
@Serializable
public data class ObjectFilter(
  /**
   * This field is used to specify the type of objects that should be included in the query
   * results.
   *
   * Objects can be filtered by their type's package, package::module, or their fully qualified
   * type name.
   *
   * Generic types can be queried by either the generic type name, e.g. `0x2::coin::Coin`, or by
   * the full type name, such as `0x2::coin::Coin<0x2::sui::SUI>`.
   */
  public val type: String? = null,
  /**
   * Filter for live objects by their current owners.
   */
  public val owner: SuiAddress? = null,
  /**
   * Filter for live objects by their IDs.
   */
  public val objectIds: List<SuiAddress>? = null,
  /**
   * Filter for live or potentially historical objects by their ID and version.
   */
  public val objectKeys: List<ObjectKey>? = null,
)
