package xyz.mcxross.ksui.generated.querytransactionblocks

import kotlinx.serialization.Serializable
import xyz.mcxross.graphql.client.Generated
import xyz.mcxross.ksui.generated.Base64
import xyz.mcxross.ksui.generated.DateTime

/**
 * The effects representing the result of executing a transaction block.
 */
@Generated
@Serializable
public data class TransactionBlockEffects(
  /**
   * Base64 encoded bcs serialization of the on-chain transaction effects.
   */
  public val bcs: Base64? = null,
  /**
   * Events emitted by this transaction block.
   */
  public val events: EventConnection? = null,
  /**
   * The checkpoint this transaction was finalized in.
   */
  public val checkpoint: Checkpoint? = null,
  /**
   * Timestamp corresponding to the checkpoint this transaction was finalized in.
   */
  public val timestamp: DateTime? = null,
  /**
   * The effect this transaction had on the balances (sum of coin values per coin type) of
   * addresses and objects.
   */
  public val balanceChanges: BalanceChangeConnection? = null,
  /**
   * The effect this transaction had on objects on-chain.
   */
  public val objectChanges: ObjectChangeConnection? = null,
)
