/*
 * Decompiled with CFR 0.152.
 */
package protocol.xyz.migoo.dubbo;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import core.xyz.migoo.sampler.SampleResult;
import core.xyz.migoo.testelement.AbstractTestElement;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericService;
import protocol.xyz.migoo.dubbo.config.DubboDefaults;
import protocol.xyz.migoo.dubbo.sampler.DubboSampleResult;
import protocol.xyz.migoo.dubbo.util.DubboConstantsInterface;

public abstract class AbstractDubboTestElement
extends AbstractTestElement
implements DubboConstantsInterface {
    protected final String name = this.getClass().getSimpleName().toLowerCase();
    protected ReferenceConfig<GenericService> reference;

    public void testStarted() {
        super.convertVariable();
        DubboDefaults other = (DubboDefaults)this.getVariables().get("migoo_protocol_dubbo_element_defaults");
        ReferenceConfig<GenericService> referenceConfig = this.reference = other == null ? this.buildReferenceConfig() : (ReferenceConfig<GenericService>)other.get("reference");
        if (other != null) {
            this.setProperty("registry_center", other.get("registry_center"));
            this.setProperty("reference_config", other.get("reference_config"));
        }
        this.reference.setInterface(this.getPropertyAsString("interface"));
        this.getVariables().put("migoo_protocol_dubbo_request_agrs", this.get("parameters"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SampleResult execute(DubboSampleResult result) throws Exception {
        result.setTestClass(this.getClass());
        result.sampleStart();
        try {
            GenericService service = (GenericService)this.reference.get();
            if (this.get("attachment_args") != null && !this.getPropertyAsJSONObject("attachment_args").isEmpty()) {
                HashMap attachments = new HashMap(16);
                this.getPropertyAsJSONObject("attachment_args").forEach((key, value) -> attachments.put(key, value.toString()));
                RpcContext.getContext().setAttachments(attachments);
                this.getVariables().put("migoo_protocol_dubbo_attachment_args", this.get("attachment_args"));
            }
            String[] parameterTypes = new String[this.getPropertyAsJSONArray("parameter_types").size()];
            for (int i = 0; i < this.getPropertyAsJSONArray("parameter_types").size(); ++i) {
                parameterTypes[i] = this.getPropertyAsJSONArray("parameter_types").getString(i);
            }
            result.setRequestData(this.getProperty());
            Object[] parameters = this.getPropertyAsJSONArray("parameters").toArray();
            Object response = service.$invoke(this.getPropertyAsString("method"), parameterTypes, parameters);
            result.setResponseData(JSON.toJSONBytes((Object)response));
        }
        finally {
            result.sampleEnd();
        }
        return result;
    }

    protected ReferenceConfig<GenericService> buildReferenceConfig() {
        JSONObject registerCenter = this.getPropertyAsJSONObject("registry_center");
        JSONObject referenceConfig = this.getPropertyAsJSONObject("reference_config");
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric("true");
        reference.setApplication(new ApplicationConfig(StringUtils.isEmpty((CharSequence)registerCenter.getString("app_name")) ? "migoo-dubbo-consumer" : registerCenter.getString("app_name")));
        reference.setVersion(referenceConfig.getString("version"));
        reference.setGroup(referenceConfig.getString("group"));
        reference.setRetries(Integer.valueOf(referenceConfig.get("retries") != null ? referenceConfig.getIntValue("retries") : 2));
        reference.setTimeout(Integer.valueOf(referenceConfig.get("timeout") != null ? referenceConfig.getIntValue("timeout") : 5000));
        reference.setAsync(Boolean.valueOf(referenceConfig.getBooleanValue("async")));
        reference.setLoadbalance(referenceConfig.get("load_balance") == null ? "random" : referenceConfig.getString("load_balance"));
        RegistryConfig registry = new RegistryConfig();
        Protocol protocol = Enum.valueOf(Protocol.class, StringUtils.isEmpty((CharSequence)registerCenter.getString("protocol")) ? "ZOOKEEPER" : registerCenter.getString("protocol").toUpperCase(Locale.ROOT));
        registry.setAddress(protocol.getProtocol() + registerCenter.getString("address"));
        registry.setGroup(registerCenter.getString("group"));
        registry.setUsername(registerCenter.getString("username"));
        registry.setPassword(registerCenter.getString("password"));
        registry.setVersion(registerCenter.getString("version"));
        reference.setRegistry(registry);
        return reference;
    }

    private static enum Protocol {
        ZOOKEEPER("zookeeper://"),
        NACOS("nacos://");

        private final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

