/*
 * Decompiled with CFR 0.152.
 */
package protocol.xyz.migoo.dubbo;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import core.xyz.migoo.sampler.SampleResult;
import core.xyz.migoo.testelement.AbstractTestElement;
import java.util.HashMap;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.ApplicationConfig;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.RegistryConfig;
import org.apache.dubbo.rpc.RpcContext;
import org.apache.dubbo.rpc.service.GenericService;
import protocol.xyz.migoo.dubbo.config.DubboDefaults;
import protocol.xyz.migoo.dubbo.sampler.DubboSampleResult;
import protocol.xyz.migoo.dubbo.util.DubboConstantsInterface;

public abstract class AbstractDubboTestElement
extends AbstractTestElement
implements DubboConstantsInterface {
    protected final String name = this.getClass().getSimpleName().toLowerCase();
    protected ReferenceConfig<GenericService> reference;

    public void testStarted() {
        DubboDefaults other = (DubboDefaults)this.getVariables().get("migoo_protocol_dubbo_element_defaults");
        if (Objects.nonNull(other)) {
            this.setProperty("registry", other.get("registry"));
            this.setProperty("reference", other.get("reference"));
        }
        this.reference = this.buildReferenceConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SampleResult execute(DubboSampleResult result) {
        result.setTestClass(this.getClass());
        result.sampleStart();
        try {
            if (this.get("attachment_args") != null && !this.getPropertyAsJSONObject("attachment_args").isEmpty()) {
                HashMap attachments = new HashMap(16);
                this.getPropertyAsJSONObject("attachment_args").forEach((key, value) -> attachments.put(key, value.toString()));
                RpcContext.getClientAttachment().setAttachments(attachments);
            }
            String[] parameterTypes = new String[this.getPropertyAsJSONArray("parameter_types").size()];
            for (int i = 0; i < this.getPropertyAsJSONArray("parameter_types").size(); ++i) {
                parameterTypes[i] = this.getPropertyAsJSONArray("parameter_types").getString(i);
            }
            result.setRequestData(this.getProperty());
            Object[] parameters = this.getPropertyAsJSONArray("parameters").toArray();
            Object response = ((GenericService)this.reference.get()).$invoke(this.getPropertyAsString("method"), parameterTypes, parameters);
            result.setResponseData(JSON.toJSONBytes((Object)response));
        }
        catch (Exception e) {
            result.setThrowable(e);
        }
        finally {
            result.sampleEnd();
        }
        return result;
    }

    protected ReferenceConfig<GenericService> buildReferenceConfig() {
        JSONObject registerCenter = Optional.ofNullable((JSONObject)this.removeProperty("registry_center")).orElse(this.getPropertyAsJSONObject("registry"));
        JSONObject referenceConfig = Optional.ofNullable((JSONObject)this.removeProperty("reference_config")).orElse(this.getPropertyAsJSONObject("reference"));
        this.setProperty("registry", registerCenter);
        this.setProperty("reference", referenceConfig);
        ReferenceConfig reference = new ReferenceConfig();
        reference.setGeneric("true");
        reference.getApplicationModel().getApplicationConfigManager().setApplication(new ApplicationConfig("migoo-dubbo-consumer"));
        reference.setVersion(referenceConfig.getString("version"));
        reference.setGroup(referenceConfig.getString("group"));
        reference.setRetries(Integer.valueOf(Math.max(referenceConfig.getIntValue("retries"), 2)));
        reference.setTimeout(Integer.valueOf(Math.max(referenceConfig.getIntValue("timeout"), 5000)));
        reference.setAsync(Boolean.valueOf(referenceConfig.getBooleanValue("async")));
        reference.setLoadbalance(referenceConfig.get("load_balance") == null ? "random" : referenceConfig.getString("load_balance"));
        reference.setInterface(this.getPropertyAsString("interface"));
        RegistryConfig registry = new RegistryConfig();
        Protocol protocol = Protocol.valueOf(StringUtils.isEmpty((CharSequence)registerCenter.getString("protocol")) ? "ZOOKEEPER" : registerCenter.getString("protocol").toUpperCase(Locale.ROOT));
        registry.setAddress(protocol.getProtocol() + registerCenter.getString("address"));
        registry.setGroup(registerCenter.getString("group"));
        registry.setUsername(registerCenter.getString("username"));
        registry.setPassword(registerCenter.getString("password"));
        registry.setVersion(registerCenter.getString("version"));
        registry.setTimeout(Integer.valueOf(Math.max(registerCenter.getIntValue("timeout"), 5000)));
        reference.setRegistry(registry);
        return reference;
    }

    private static enum Protocol {
        ZOOKEEPER("zookeeper://"),
        NACOS("nacos://");

        private final String protocol;

        private Protocol(String protocol) {
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

