/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.extender;

import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import xyz.migoo.mise.exception.ExtenderException;
import xyz.migoo.mise.extender.ExtenderHelper;
import xyz.migoo.mise.report.MiSeLog;

public class MethodHelper {
    private static final String SEPARATOR = ",";
    private static final Pattern REGEX_LONG = Pattern.compile("^[-\\+]?[0-9]+$");
    private static final Pattern REGEX_FLOAT = Pattern.compile("^[-\\+]?[0-9]+\\.[0-9]+$");

    static Map<String, Method> loadFunction(Object[] classes) throws ExtenderException {
        if (classes == null) {
            return new HashMap<String, Method>(0);
        }
        try {
            HashMap<String, Method> map = new HashMap<String, Method>(100);
            for (Object clazz : classes) {
                for (Class<?> clz = Class.forName((String)clazz); clz != null && clz != Object.class; clz = clz.getSuperclass()) {
                    Method[] methods;
                    for (Method method : methods = clz.getDeclaredMethods()) {
                        String key = String.format("%s(%s)", method.getName(), method.getParameterCount());
                        map.put(key, method);
                    }
                }
            }
            return map;
        }
        catch (Exception e) {
            throw new ExtenderException(e.getMessage());
        }
    }

    private static Object[] loadParameter(String params, JSONObject variables) throws RuntimeException {
        if (params == null || "".equals(params.trim())) {
            return null;
        }
        String[] strParams = params.split(SEPARATOR);
        Object[] parameters = new Object[strParams.length];
        for (int i = 0; i < strParams.length; ++i) {
            MethodHelper.parseParameter(parameters, strParams[i], i);
            if (parameters[i] != null) continue;
            MethodHelper.parseParameter(parameters, strParams[i], i, variables);
        }
        return parameters;
    }

    private static void parseParameter(Object[] parameters, String parameter, int index) {
        if (REGEX_LONG.matcher(parameter).find()) {
            parameters[index] = Long.valueOf(parameter);
        } else if (REGEX_FLOAT.matcher(parameter).find()) {
            parameters[index] = Double.valueOf(parameter);
        } else if ("true".equalsIgnoreCase(parameter) || "false".equalsIgnoreCase(parameter)) {
            parameters[index] = Boolean.valueOf(parameter);
        }
    }

    private static void parseParameter(Object[] parameters, String parameter, int index, JSONObject variables) {
        Matcher param = ExtenderHelper.PARAM_PATTERN.matcher(parameter);
        if (param.find() && variables != null && !variables.isEmpty()) {
            Object object = variables.get((Object)parameter.substring(2, parameter.length() - 1));
            if (ExtenderHelper.FUNC_PATTERN.matcher(String.valueOf(object)).find() || ExtenderHelper.PARAM_PATTERN.matcher(String.valueOf(object)).find()) {
                throw new RuntimeException(String.format("%s need eval!", param.group(1)));
            }
            parameters[index] = object;
            return;
        }
        parameters[index] = parameter;
    }

    private static Method method(Map<String, Method> methods, String name, Object[] params) {
        if (params == null) {
            return methods.get(String.format("%s(0)", name));
        }
        return methods.get(String.format("%s(%s)", name, params.length));
    }

    static Object invoke(Map<String, Method> methods, String name, String parameter, JSONObject variables) throws ExtenderException {
        Object result;
        try {
            Object[] parameters = MethodHelper.loadParameter(parameter, variables);
            result = MethodHelper.method(methods, name, parameters).invoke(null, parameters);
            MiSeLog.log(String.format("invoke success, method [%s] -> parameter [%s] -> return [%s]", name, parameter, result));
        }
        catch (NullPointerException e) {
            throw new ExtenderException(String.format("method '%s(%s)' not found !", name, parameter));
        }
        catch (Exception e) {
            throw new ExtenderException(String.format("invoke error, method name '%s', parameter '%s'", name, parameter), e);
        }
        return result;
    }
}

