/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.framework;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import xyz.migoo.mise.exception.ExtenderException;
import xyz.migoo.mise.extender.ExtenderHelper;
import xyz.migoo.mise.framework.Step;
import xyz.migoo.mise.framework.Test;
import xyz.migoo.mise.report.MiSeLog;

public abstract class AbstractTest
implements Test {
    private long startTime = System.currentTimeMillis();
    private long endTime = 0L;
    private String fName;
    private JSONArray setUp = new JSONArray();
    private JSONArray teardown = new JSONArray();
    List<Step> steps;
    JSONObject variables = new JSONObject();

    AbstractTest(String name) {
        this.fName = name;
    }

    public String getName() {
        return this.fName;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public void addVariables(JSONObject variables) {
        if (variables != null) {
            this.variables.putAll((Map)variables);
        }
    }

    void addSetUp(JSONArray setUp) {
        if (setUp != null) {
            this.setUp.addAll((Collection)setUp);
        }
    }

    public void setUp(String type) throws ExtenderException {
        MiSeLog.log("{} begin", type);
        for (int i = 0; i < this.setUp.size(); ++i) {
            ExtenderHelper.hook(this.setUp.getString(i), this.variables);
        }
        MiSeLog.log("{} end", type);
    }

    void addTeardown(JSONArray teardown) {
        if (teardown != null) {
            this.teardown.addAll((Collection)teardown);
        }
    }

    void teardown(String type) {
        MiSeLog.log("{} begin", type);
        this.teardown.forEach(value -> {
            try {
                ExtenderHelper.hook((String)value, this.variables);
            }
            catch (ExtenderException e) {
                MiSeLog.log(value + " error", e);
            }
        });
        MiSeLog.log("{} end", type);
    }

    public long duration() {
        return this.endTime - this.startTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }
}

