/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.framework;

import java.util.ArrayList;
import java.util.List;
import xyz.migoo.mise.framework.AbstractTest;
import xyz.migoo.mise.framework.TestFailure;
import xyz.migoo.mise.framework.assertion.AssertionFailure;
import xyz.migoo.mise.framework.assertion.SkippedRun;

public class TestResult {
    private List<TestFailure> fFailures = new ArrayList<TestFailure>();
    private List<TestFailure> fErrors = new ArrayList<TestFailure>();
    private List<TestFailure> fSkips = new ArrayList<TestFailure>();
    private List<AbstractTest> fSuccess = new ArrayList<AbstractTest>();
    private String rName;
    private int fRunTests;
    private long startTime;
    private long endTime;
    private boolean fStop;

    public TestResult(int fRunTests, String name) {
        this.fRunTests = fRunTests;
        this.fStop = false;
        this.rName = name;
    }

    synchronized void addError(AbstractTest test, Throwable t) {
        this.fErrors.add(new TestFailure(test, t));
    }

    synchronized void addFailure(AbstractTest test, AssertionFailure t) {
        this.fFailures.add(new TestFailure(test, t));
    }

    synchronized void addSkip(AbstractTest test, SkippedRun skip) {
        this.fSkips.add(new TestFailure(test, skip));
    }

    synchronized void addSuccess(AbstractTest test) {
        this.fSuccess.add(test);
    }

    public synchronized int errorCount() {
        return this.fErrors.size();
    }

    public synchronized List<TestFailure> errors() {
        return this.fErrors;
    }

    public synchronized int failureCount() {
        return this.fFailures.size();
    }

    public synchronized List<TestFailure> failures() {
        return this.fFailures;
    }

    public synchronized int skipCount() {
        return this.fSkips.size();
    }

    public synchronized List<TestFailure> skips() {
        return this.fSkips;
    }

    public synchronized int successCount() {
        return this.fSuccess.size();
    }

    public synchronized List<AbstractTest> success() {
        return this.fSuccess;
    }

    public synchronized int caseCount() {
        return this.fRunTests;
    }

    public String getName() {
        return this.rName;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }
}

