/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.framework;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.Vector;
import xyz.migoo.mise.exception.ExtenderException;
import xyz.migoo.mise.extender.ExtenderHelper;
import xyz.migoo.mise.framework.AbstractTest;
import xyz.migoo.mise.framework.Test;
import xyz.migoo.mise.framework.TestCase;
import xyz.migoo.mise.framework.TestResult;
import xyz.migoo.mise.framework.selenium.DriverBuilder;
import xyz.migoo.mise.framework.selenium.MiSe;
import xyz.migoo.mise.report.MiSeLog;

public class TestSuite
extends AbstractTest {
    private Vector<TestCase> fTests = new Vector(10);
    private MiSe miSe;

    public TestSuite(JSONObject suite) {
        super(suite.getString("name"));
        this.initSuite(suite.getJSONObject("config"));
        JSONArray cases = suite.getJSONArray("case");
        for (int i = 0; i < cases.size(); ++i) {
            this.addTest(new TestCase(cases.getJSONObject(i)));
        }
    }

    public TestSuite browser(String browser, JSONObject config) {
        DriverBuilder builder = MiSe.builder().browser(browser);
        if (config != null) {
            builder.bin(config.getString("bin")).driverBin(config.getString("driver"));
        }
        this.miSe = builder.build();
        return this;
    }

    @Override
    public int countTestCases() {
        int count = 0;
        for (Test test : this.fTests) {
            count += test.countTestCases();
        }
        return count;
    }

    @Override
    public void run(TestResult result) {
        MiSeLog.log("===================================================================");
        MiSeLog.log("test suite begin: {}", this.getName());
        try {
            ExtenderHelper.bindAndEval(this.variables, this.variables);
            this.setUp("suite setup");
            this.fTests.forEach(test -> {
                test.addVariables(this.variables);
                test.setMiSe(this.miSe).run(result);
            });
            this.teardown("suite teardown");
        }
        catch (Exception e) {
            try {
                MiSeLog.log("test run error: {}", e);
                this.teardown("suite teardown");
            }
            catch (Throwable throwable) {
                this.teardown("suite teardown");
                MiSeLog.log("test suite end: {}", this.getName());
                throw throwable;
            }
            MiSeLog.log("test suite end: {}", this.getName());
        }
        MiSeLog.log("test suite end: {}", this.getName());
    }

    private void addTest(TestCase test) {
        this.fTests.add(test);
    }

    private void initSuite(JSONObject config) {
        super.addVariables(config.getJSONObject("variables"));
        super.addSetUp(config.getJSONArray("setup"));
        super.addTeardown(config.getJSONArray("teardown"));
    }

    @Override
    public void setUp(String type) throws ExtenderException {
        this.miSe.implicitlyWait(60).pageLoadTimeout(60).maximize();
        super.setUp(type);
    }

    @Override
    public void teardown(String type) {
        super.teardown(type);
        this.miSe.close();
        this.miSe.quit();
    }
}

