/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.framework.assertion;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import xyz.migoo.mise.framework.selenium.MiSe;
import xyz.migoo.mise.utils.StringUtil;

public abstract class AbstractAssertion {
    private JSONObject validate;
    protected Object actual;
    protected Object expected;
    private static ThreadLocal<DecimalFormat> decimalFormatter = ThreadLocal.withInitial(AbstractAssertion::createDecimalFormat);

    private static DecimalFormat createDecimalFormat() {
        DecimalFormat decimalFormatter = new DecimalFormat("#.#");
        decimalFormatter.setMaximumFractionDigits(340);
        decimalFormatter.setMinimumFractionDigits(1);
        return decimalFormatter;
    }

    public AbstractAssertion() {
    }

    public AbstractAssertion(Object actual, Object expected) {
        this.actual = actual;
        this.expected = expected;
    }

    protected String objectToString(Object subj) {
        String str = subj == null || StringUtil.isEmpty(subj.toString()) ? "null" : (subj instanceof List ? (((List)subj).isEmpty() ? "null" : JSONArray.toJSONString((Object)subj)) : (subj instanceof Map ? (((Map)subj).isEmpty() ? "null" : JSONObject.toJSONString((Object)subj)) : (subj instanceof Double || subj instanceof Float ? decimalFormatter.get().format(subj) : subj.toString())));
        return str;
    }

    public void setValidate(JSONObject validate) {
        this.validate = validate;
    }

    public void setExpected(Object expected) {
        this.expected = expected;
    }

    public void actual() {
        Object obj = this.validate.get((Object)"actual");
        if (obj instanceof JSONObject) {
            this.setActualByDriver((JSONObject)obj);
        } else {
            this.actual = obj;
        }
    }

    public Object getActual() {
        return this.actual;
    }

    public Object getExpected() {
        return this.expected;
    }

    public abstract boolean assertThat() throws Exception;

    private void setActualByDriver(JSONObject json) {
        MiSe miSe = (MiSe)this.validate.get((Object)"driver");
        switch (json.getString("operation")) {
            case "isSelected": {
                this.actual = miSe.isSelected(json.getString("selector"));
                break;
            }
            case "isEnabled": {
                this.actual = miSe.isEnabled(json.getString("selector"));
                break;
            }
            case "isDisplayed": {
                this.actual = miSe.isDisplayed(json.getString("selector"));
                break;
            }
            case "getAttribute": {
                this.actual = miSe.getAttribute(json.getString("selector"), json.getString("object"));
                break;
            }
            case "getCurrentUrl": {
                this.actual = miSe.getCurrentUrl();
                break;
            }
            case "getTitle": {
                this.actual = miSe.getTitle();
                break;
            }
            case "getPageSource": {
                this.actual = miSe.getPageSource();
                break;
            }
            default: {
                this.actual = miSe.getText(json.getString("selector"));
            }
        }
    }
}

