/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.framework.selenium;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import java.io.File;
import java.util.regex.Pattern;
import org.openqa.selenium.PageLoadStrategy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxOptions;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.safari.SafariDriver;
import org.openqa.selenium.safari.SafariOptions;
import xyz.migoo.mise.exception.MiSeException;
import xyz.migoo.mise.framework.selenium.MiSe;

public class DriverBuilder {
    private static final Pattern PATTERN = Pattern.compile("^http[s]*://[\\w\\.\\-]+(:\\d*)*(?:/|(?:/[\\w\\.\\-]+)*)?$", 2);
    private WebDriver driver;
    private String browser;
    private File bin;
    private String exePath;
    private BrowserVersion version;
    private Boolean headless = Boolean.FALSE;

    DriverBuilder() {
    }

    WebDriver driver() {
        return this.driver;
    }

    public DriverBuilder browser(String browser) {
        this.browser = browser;
        return this;
    }

    public DriverBuilder chrome() {
        this.browser = "chrome";
        return this;
    }

    public DriverBuilder firefox() {
        this.browser = "firefox";
        return this;
    }

    public DriverBuilder safari() {
        this.browser = "safari";
        return this;
    }

    public DriverBuilder htmlUnit() {
        return this.htmlUnit(BrowserVersion.FIREFOX_60);
    }

    public DriverBuilder htmlUnit(BrowserVersion version) {
        this.browser = "htmlunit";
        if (version != null) {
            this.version = version;
        }
        return this;
    }

    public DriverBuilder bin(String bin) {
        if (!"".equals(bin) && bin != null) {
            this.bin = new File(bin);
            if (!this.bin.exists() || this.bin.isDirectory()) {
                throw new MiSeException("browser bin not exists or is directory");
            }
        }
        return this;
    }

    public DriverBuilder driverBin(String exePath) {
        if (!"".equals(exePath) && exePath != null) {
            File driverBin = new File(exePath);
            if (!driverBin.exists() || driverBin.isDirectory()) {
                throw new MiSeException("driver bin not exists or is directory");
            }
            this.exePath = exePath;
        }
        return this;
    }

    public DriverBuilder headless(boolean headless) {
        this.headless = headless;
        return this;
    }

    private void setDriver() {
        if ("firefox".equals(this.browser)) {
            System.setProperty("webdriver.gecko.driver", this.exePath);
            this.firefoxOptions();
        } else if ("chrome".equals(this.browser)) {
            System.setProperty("webdriver.chrome.driver", this.exePath);
            this.chromeOptions();
        } else if ("safari".equals(this.browser)) {
            this.safariOptions();
        } else {
            this.htmlUnitOptions();
        }
    }

    private void firefoxOptions() {
        FirefoxOptions options = new FirefoxOptions();
        if (this.bin != null) {
            FirefoxBinary binary = new FirefoxBinary(this.bin);
            options.setBinary(binary);
        }
        options.setHeadless(this.headless.booleanValue());
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        this.driver = new FirefoxDriver(options);
    }

    private void chromeOptions() {
        ChromeOptions options = new ChromeOptions();
        if (this.bin != null) {
            options.setBinary(this.bin);
        }
        options.setPageLoadStrategy(PageLoadStrategy.NORMAL);
        options.setHeadless(this.headless.booleanValue());
        this.driver = new ChromeDriver(options);
    }

    private void safariOptions() {
        SafariOptions options = new SafariOptions();
        this.driver = new SafariDriver(options);
    }

    private void htmlUnitOptions() {
        this.driver = this.version != null ? new HtmlUnitDriver(this.version, true) : new HtmlUnitDriver(true);
    }

    public MiSe build() {
        if ("".equals(this.browser) || null == this.browser) {
            throw new MiSeException("browser == null");
        }
        this.setDriver();
        return new MiSe(this);
    }
}

