/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.framework.selenium;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import xyz.migoo.mise.exception.MiSeException;
import xyz.migoo.mise.framework.selenium.DriverBuilder;
import xyz.migoo.mise.report.MiSeLog;

public class MiSe {
    private WebDriver driver;
    private static final String XPATH_1 = ".//";
    private static final String XPATH_2 = "//";

    public static DriverBuilder builder() {
        return new DriverBuilder();
    }

    MiSe(DriverBuilder builder) {
        this.driver = builder.driver();
    }

    public MiSe implicitlyWait(int time) {
        if (this.driver != null) {
            this.driver.manage().timeouts().implicitlyWait((long)time, TimeUnit.SECONDS);
        }
        return this;
    }

    public MiSe pageLoadTimeout(int time) {
        if (this.driver != null) {
            this.driver.manage().timeouts().pageLoadTimeout((long)time, TimeUnit.SECONDS);
        }
        return this;
    }

    public MiSe maximize() {
        if (this.driver != null) {
            this.driver.manage().window().maximize();
            MiSeLog.log("window maximize");
        }
        return this;
    }

    public void get(String url) {
        this.driver.get(url);
        MiSeLog.log("goto url: {}", url);
    }

    public String getCurrentUrl() {
        MiSeLog.log("get current url: {}", this.driver.getCurrentUrl());
        return this.driver.getCurrentUrl();
    }

    public String getTitle() {
        MiSeLog.log("get title: {}", this.driver.getTitle());
        return this.driver.getTitle();
    }

    public WebElement findElement(String selector) {
        return this.driver.findElement(this.parseSelector(selector));
    }

    public List<WebElement> findElements(String selector) {
        return this.driver.findElements(this.parseSelector(selector));
    }

    public String getPageSource() {
        MiSeLog.log("get page source");
        return this.driver.getPageSource();
    }

    public void close() {
        if (this.driver != null) {
            MiSeLog.log("window close: {}", this.driver.getWindowHandle());
            this.driver.close();
        }
    }

    public void quit() {
        if (this.driver != null) {
            MiSeLog.log("driver quit");
            this.driver.quit();
        }
    }

    public void addCookie(Object cookie) {
        Cookie c;
        if (cookie instanceof String) {
            JSONObject json = JSONObject.parseObject((String)cookie.toString());
            c = new Cookie(json.getString("name"), json.getString("value"), json.getString("domain"), json.getString("path"), json.getDate("expiry"));
        } else if (cookie instanceof JSONObject) {
            JSONObject json = (JSONObject)cookie;
            c = new Cookie(json.getString("name"), json.getString("value"), json.getString("domain"), json.getString("path"), json.getDate("expiry"));
        } else {
            c = (Cookie)cookie;
        }
        MiSeLog.log("add cookie: {}", c);
        this.driver.manage().addCookie(c);
    }

    public Set<Cookie> getCookies() {
        MiSeLog.log("get cookie");
        return this.driver.manage().getCookies();
    }

    public void refresh() {
        MiSeLog.log("driver refresh");
        this.driver.navigate().refresh();
    }

    public void back() {
        MiSeLog.log("driver back");
        this.driver.navigate().back();
    }

    public void click(String selector) {
        MiSeLog.log("click: {}", selector);
        this.findElement(selector).click();
    }

    public void submit(String selector) {
        MiSeLog.log("submit: {}", selector);
        this.findElement(selector).submit();
    }

    public void sendKeys(String selector, String keysToSend) {
        this.findElement(selector).clear();
        this.findElement(selector).sendKeys(new CharSequence[]{keysToSend});
        MiSeLog.log("find element: {}, sendKeys: {}", selector, keysToSend);
    }

    public String getAttribute(String selector, String name) {
        String value = this.findElement(selector).getAttribute(name);
        MiSeLog.log("find element: {}, attribute: {}, value: {}", selector, name, value);
        return value;
    }

    public boolean isSelected(String selector) {
        boolean result = this.findElement(selector).isSelected();
        MiSeLog.log("find element: {}, isSelected: {}", selector, result);
        return result;
    }

    public boolean isEnabled(String selector) {
        boolean result = this.findElement(selector).isEnabled();
        MiSeLog.log("find element: {}, isEnabled: {}", selector, result);
        return result;
    }

    public String getText(String selector) {
        String text = this.findElement(selector).getText();
        MiSeLog.log("find element: {}, text: {}", selector, text);
        return text;
    }

    public boolean isDisplayed(String selector) {
        boolean result = this.findElement(selector).isDisplayed();
        MiSeLog.log("find element: {}, isDisplayed: {}", selector, result);
        return result;
    }

    private By parseSelector(String selector) {
        if (selector.startsWith(XPATH_1) || selector.startsWith(XPATH_2)) {
            selector = String.format("%s=%s", "xpath", selector);
        }
        if (selector.startsWith("id=")) {
            return By.id((String)selector.substring(selector.indexOf("=") + 1));
        }
        if (selector.startsWith("css=")) {
            return By.cssSelector((String)selector.substring(selector.indexOf("=") + 1));
        }
        if (selector.startsWith("xpath=")) {
            return By.xpath((String)selector.substring(selector.indexOf("=") + 1));
        }
        if (selector.startsWith("link=")) {
            return By.linkText((String)selector.substring(selector.indexOf("=") + 1));
        }
        if (selector.startsWith("partiallink=")) {
            return By.partialLinkText((String)selector.substring(selector.indexOf("=") + 1));
        }
        if (selector.startsWith("class=")) {
            return By.className((String)selector.substring(selector.indexOf("=") + 1));
        }
        if (selector.startsWith("tagname=")) {
            return By.tagName((String)selector.substring(selector.indexOf("=") + 1));
        }
        if (selector.startsWith("name=")) {
            return By.name((String)selector.substring(selector.indexOf("=") + 1));
        }
        throw new MiSeException(String.format("unknown selector '%s'.", selector));
    }
}

