/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.loader.reader;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import xyz.migoo.mise.loader.reader.Reader;
import xyz.migoo.mise.loader.reader.ReaderException;
import xyz.migoo.mise.loader.reader.YamlReader;

public class ReaderFactory {
    public static final String JSON_SUFFIX = ".json";
    public static final String YAML_SUFFIX = ".yml";
    public static final String PROS_SUFFIX = ".properties";
    public static final String XLS_SUFFIX = ".xls";
    public static final String XLSX_SUFFIX = ".xlsx";
    private static final List<String> LIST;

    public static Reader getReader(String path) throws ReaderException {
        if (YAML_SUFFIX.equals(ReaderFactory.suffix(path))) {
            return new YamlReader(path);
        }
        throw new ReaderException("file reader error");
    }

    private static String suffix(String file) {
        String suffix = file.substring(file.lastIndexOf("."));
        if (LIST.contains(suffix)) {
            return suffix;
        }
        return null;
    }

    static {
        Field[] fields;
        LIST = new ArrayList<String>();
        for (Field field : fields = ReaderFactory.class.getDeclaredFields()) {
            try {
                if ("LIST".equals(field.getName())) continue;
                LIST.add(field.get(ReaderFactory.class).toString());
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }
}

