/*
 * Decompiled with CFR 0.152.
 */
package xyz.migoo.mise.report;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import xyz.migoo.mise.config.Platform;
import xyz.migoo.mise.framework.AbstractTest;
import xyz.migoo.mise.framework.TestFailure;
import xyz.migoo.mise.framework.TestResult;
import xyz.migoo.mise.loader.reader.AbstractReader;
import xyz.migoo.mise.report.Email;
import xyz.migoo.mise.report.MiSeLog;
import xyz.migoo.mise.report.ReportException;
import xyz.migoo.mise.utils.DateUtil;

public class Report {
    private static final TemplateEngine TEMPLATE_ENGINE = new TemplateEngine();
    private List<TestResult> results;
    private Map<String, Object> report = new HashMap<String, Object>(3);
    private int total = 0;
    private int success = 0;
    private int failed = 0;
    private int error = 0;
    private int skipped = 0;

    public Report() {
        this.mkDirs();
        this.results = new ArrayList<TestResult>();
    }

    public void setProjectName(String projectName) {
        this.report.put("projectName", projectName);
    }

    public void addResult(TestResult result) {
        this.results.add(result);
        this.total += result.caseCount();
        this.success += result.successCount();
        this.failed += result.failureCount();
        this.error += result.errorCount();
        this.skipped += result.skipCount();
    }

    public void generateIndex() {
        this.report.put("records", this.records());
        this.report.put("summary", this.summary());
        String template = HtmlReader.read("classpath://templates/index_report_template.html");
        String content = this.render(template, this.report);
        this.report("index", content, true);
        if (Platform.MAIL_SEND) {
            Email.sendEmail(content);
        }
    }

    private List<Map<String, Object>> records() {
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        AtomicInteger id = new AtomicInteger();
        this.results.forEach(result -> {
            HashMap<String, Object> record = new HashMap<String, Object>(8);
            record.put("id", id.get());
            record.put("title", result.getName());
            record.put("link", "./html/" + result.getName() + ".html");
            record.put("total", result.caseCount());
            record.put("success", result.successCount());
            record.put("failed", result.failureCount());
            record.put("error", result.errorCount());
            record.put("skipped", result.skipCount());
            records.add(record);
            id.getAndIncrement();
        });
        return records;
    }

    private Map<String, Object> summary() {
        HashMap<String, Object> summary = new HashMap<String, Object>(5);
        summary.put("total", this.total);
        summary.put("success", this.success);
        summary.put("failed", this.failed);
        summary.put("error", this.error);
        summary.put("skipped", this.skipped);
        return summary;
    }

    public void generateReport() {
        HashMap report = new HashMap(5);
        String template = HtmlReader.read("classpath://templates/mise_report_template.html");
        this.results.forEach(result -> {
            report.put("summary", this.summary((TestResult)result));
            report.put("records", this.records((TestResult)result));
            report.put("report", result.getName());
            report.put("title", result.getName());
            String content = this.render(template, report);
            this.report(result.getName(), content, false);
        });
    }

    private Map<String, Object> summary(TestResult result) {
        HashMap<String, Object> summary = new HashMap<String, Object>(7);
        summary.put("startAt", DateUtil.format("yyyy-MM-dd HH:mm:ss", result.getStartTime()));
        summary.put("duration", (float)(result.getEndTime() - result.getStartTime()) / 1000.0f + " seconds");
        summary.put("total", result.caseCount());
        summary.put("success", result.successCount());
        summary.put("failed", result.failureCount());
        summary.put("error", result.errorCount());
        summary.put("skipped", result.skipCount());
        return summary;
    }

    private List<Map<String, Object>> records(TestResult result) {
        ArrayList<Map<String, Object>> records = new ArrayList<Map<String, Object>>();
        int id = 1;
        for (TestFailure testFailure : result.errors()) {
            records.add(this.item(testFailure, null, id, "error"));
            ++id;
        }
        for (TestFailure testFailure : result.failures()) {
            records.add(this.item(testFailure, null, id, "failure"));
            ++id;
        }
        for (TestFailure testFailure : result.skips()) {
            records.add(this.item(testFailure, null, id, "skipped"));
            ++id;
        }
        for (AbstractTest test : result.success()) {
            records.add(this.item(null, test, id, "success"));
            ++id;
        }
        return records;
    }

    private Map<String, Object> item(TestFailure testFailure, AbstractTest test, int id, String status) {
        AbstractTest t = test != null ? test : testFailure.failedTest();
        HashMap<String, Object> item = new HashMap<String, Object>(6);
        item.put("status", status);
        item.put("name", t.getName());
        String time = test != null ? (float)test.duration() / 1000.0f + "  s" : "N/A";
        item.put("time", time);
        item.put("detail", this.detail(t, testFailure, id));
        item.put("record_id", "record_" + id);
        item.put("record_href", "#record_" + id);
        return item;
    }

    private synchronized Map<String, Object> detail(AbstractTest test, TestFailure testFailure, int id) {
        HashMap<String, Object> detail = new HashMap<String, Object>(7);
        detail.put("steps", test.getSteps());
        if (testFailure != null) {
            detail.put("track", testFailure.trace());
        }
        detail.put("track_id", "track_" + id);
        detail.put("steps_id", "steps_" + id);
        detail.put("track_href", "#track_" + id);
        detail.put("steps_href", "#steps_" + id);
        return detail;
    }

    private String render(String template, Map<String, Object> report) {
        Context context = new Context();
        context.setVariables(report);
        return TEMPLATE_ENGINE.process(template, (IContext)context);
    }

    private void mkDirs() {
        File file = new File(String.format("%s/reports/%s/html", System.getProperty("user.dir"), DateUtil.TODAY_DATE));
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void report(String name, String content, boolean isIndex) {
        String path = isIndex ? String.format("%s/reports/%s/index.html", System.getProperty("user.dir"), DateUtil.TODAY_DATE) : String.format("%s/reports/%s/html/%s.html", System.getProperty("user.dir"), DateUtil.TODAY_DATE, name);
        try (FileWriter writer = new FileWriter(path);){
            writer.write(content);
        }
        catch (Exception e) {
            throw new ReportException("create report error , file path " + path, e);
        }
    }

    private static class HtmlReader
    extends AbstractReader {
        private static HtmlReader htmlReader = new HtmlReader();

        private HtmlReader() {
        }

        private static String read(String path) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                String line;
                htmlReader.stream("html", path);
                BufferedReader reader = new BufferedReader(new InputStreamReader(HtmlReader.htmlReader.inputStream));
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line).append("\n");
                }
            }
            catch (Exception e) {
                MiSeLog.log(e.getMessage(), e);
            }
            return stringBuilder.toString();
        }
    }
}

