/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.consts;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;

public interface RegexPattern {
    public static final String INTEGER = "^(0|-*[1-9][0-9]*)$";
    public static final String POSITIVE_INTEGER_OR_ZERO = "^(0|[1-9][0-9]*)$";
    public static final String POSITIVE_INTEGER = "^[1-9]\\d*$";
    public static final String NON_NEGATIVE_INTEGER = "^\\d+$";
    public static final String NEGATIVE_INTEGER = "^-[1-9]\\d*$";
    public static final String NON_POSITIVE_INTEGER = "^((-\\d+)|(0+))$";
    public static final String POSITIVE_NUMBER_TWO_DECIMALS_MOST = "^([1-9][0-9]*)+(.[0-9]{1,2})?$";
    public static final String REAL_NUMBER = "^(\\-|\\+)?\\d+(\\.\\d+)?$";
    public static final String REAL_NUMBER_2_DECIMALS_OPTIONAL = "^(\\-)?\\d+(\\.\\d{1,2})?$";
    public static final String NON_NEGATIVE_REAL_NUMBER_2_DECIMALS_ONLY = "^[0-9]+(.[0-9]{2})?$";
    public static final String NON_NEGATIVE_REAL_NUMBER_3_DECIMALS_OPTIONAL = "^[0-9]+(.[0-9]{1,3})?$";
    public static final String NON_NEGATIVE_FLOAT = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0$";
    public static final String NON_POSITIVE_FLOAT = "^(-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*))|0?\\.0+|0$";
    public static final String POSITIVE_FLOAT = "^[1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*$";
    public static final String NEGATIVE_FLOAT = "^-([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*)$";
    public static final String FLOAT = "^-?([1-9]\\d*\\.\\d*|0\\.\\d*[1-9]\\d*|0?\\.0+|0)$";
    public static final String CHINESE = "^[\\u4e00-\\u9fa5]{0,}$";
    public static final String ENGLISH_AND_NUMBER = "^[A-Za-z0-9]+$";
    public static final String ENGLISH = "^[A-Za-z]+$";
    public static final String ENGLISH_UPPERCASE = "^[A-Z]+$";
    public static final String ENGLISH_LOWERCASE = "^[a-z]+$";
    public static final String ENGLISH_NUMBER_UNDERLINE = "^\\w+$";
    public static final String EN_CN_NUM_UNDERLINE = "^[\\u4E00-\\u9FA5A-Za-z0-9_]+$";
    public static final String EN_CN_NUM = "^[\\u4E00-\\u9FA5A-Za-z0-9]+$";
    public static final String EMAIL = "^\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*$";
    public static final String DOMAIN = "^(?=^.{3,255}$)[a-zA-Z0-9][-a-zA-Z0-9]{0,62}(\\.[a-zA-Z0-9][-a-zA-Z0-9]{0,62})+$";
    public static final String HTTP_FTP_URL = "^((ht|f)tps?):\\/\\/[\\w\\-]+(\\.[\\w\\-]+)+([\\w\\-\\.,@?^=%&:\\/~\\+#]*[\\w\\-\\@?^=%&\\/~\\+#])?$";
    public static final String CHINESE_MOBILE_NO = "^[1]([3-9])[0-9]{9}$";
    public static final String CHINESE_PHONE_NO = "[0-9-()\uff08\uff09]{7,18}";
    public static final String ID_CARD = "\\d{17}[\\d|x]|\\d{15}";
    public static final String ACCOUNT_CHECK = "^[a-zA-Z][a-zA-Z0-9_]{4,15}$";
    public static final String YYYY_MM_DD = "^(?:(?!0000)[0-9]{4}-(?:(?:0[1-9]|1[0-2])-(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])-(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)$";
    public static final String MONTH_NUMBER = "^(0?[1-9]|1[0-2])$";
    public static final String DAY_RANGE = "^((0?[1-9])|((1|2)[0-9])|30|31)$";
    public static final String ZIP_CODE = "^[0-9]{6}$";
    public static final String IP_V4 = "^((25[0-5]|2[0-4]\\d|[01]?\\d\\d?)\\.){3}(25[0-5]|2[0-4]\\d|[01]?\\d\\d?)$";
    public static final String IP_V6 = "^([\\da-fA-F]{1,4}:){7}[\\da-fA-F]{1,4}$";

    public static String limitNumber(int n) {
        if (n <= 0) {
            throw new RuntimeException("n\u5fc5\u987b\u5927\u4e8e0");
        }
        return "^\\d{" + n + "}$";
    }

    public static String leastNumber(int n) {
        if (n <= 0) {
            n = 1;
        }
        return "^\\d{" + n + ",}$";
    }

    public static String rangedNumber(int m, int n) {
        if (m <= 0) {
            throw new RuntimeException("m\u5fc5\u987b\u5927\u4e8e0");
        }
        if (n <= 0) {
            throw new RuntimeException("n\u5fc5\u987b\u5927\u4e8e0");
        }
        if (m > n) {
            throw new RuntimeException("m\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8en");
        }
        return "^\\d{" + m + "," + n + "}$";
    }

    public static String limitInt(int n) {
        if (n <= 0) {
            throw new RuntimeException("n\u5fc5\u987b\u5927\u4e8e0");
        }
        if (n == 1) {
            return "^(0|[1-9]|-[1-9])$";
        }
        return "^(-?[1-9]\\d{" + --n + "})$";
    }

    public static String leastInt(int n) {
        if (n <= 0 || n == 1) {
            return "^(0|-[1-9]\\d{0,}|[1-9]\\d{0,})$";
        }
        return "^(0|-[1-9]\\d{" + --n + ",}|[1-9]\\d{" + n + ",})$";
    }

    public static String rangedInt(int m, int n) {
        if (m > n) {
            throw new RuntimeException("m\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8en");
        }
        if (m <= 0) {
            throw new RuntimeException("m\u5fc5\u987b\u5927\u4e8e0");
        }
        if (m == 1 && n == 1) {
            return "^(0|[1-9]|-[1-9])$";
        }
        return "^(-?[1-9]\\d{" + --m + "," + --n + "})$";
    }

    public static String strongPwdRegex(int m, int n) {
        int least = 4;
        if (m < least) {
            throw new RuntimeException("\u5bc6\u7801\u81f3\u5c11\u662f4\u4f4d,m>=4");
        }
        if (m > n) {
            throw new RuntimeException("m\u5fc5\u987b\u5c0f\u4e8e\u7b49\u4e8en");
        }
        return "^(?=.*\\d)(?=.*[a-z])(?=.*[A-Z]).{" + m + "," + n + "}$";
    }

    public static boolean isRegexMatch(String origin, @NotNull String regex) {
        Pattern pat = Pattern.compile(regex);
        Matcher matcher = pat.matcher(origin);
        return matcher.matches();
    }
}

