/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.request;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.shodown.common.util.io.XssUtil;

public class XssBodyRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger((String)"platform");
    private String body;
    private String errMsg;

    public XssBodyRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.errMsg = request.getRequestURI() + "\u8bf7\u6c42\u7684body\u4e2d\u5305\u542b\u975e\u6cd5\u5185\u5bb9;";
        StringBuilder stringBuilder = new StringBuilder();
        try (ServletInputStream inputStream = request.getInputStream();){
            String tmp;
            if (inputStream != null) {
                try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)inputStream));){
                    char[] charBuffer = new char[128];
                    int bytesRead = -1;
                    while ((bytesRead = bufferedReader.read(charBuffer)) > 0) {
                        stringBuilder.append(charBuffer, 0, bytesRead);
                    }
                }
            }
            if (XssUtil.cleanXssAndSqlIllegals(tmp = stringBuilder.toString())) {
                log.error(this.errMsg);
            }
            this.body = tmp;
        }
    }

    public ServletInputStream getInputStream() throws IOException {
        final ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.body.getBytes());
        ServletInputStream servletInputStream = new ServletInputStream(){

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener readListener) {
            }

            public int read() throws IOException {
                return byteArrayInputStream.read();
            }
        };
        return servletInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getBody() {
        return this.body;
    }
}

