/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.encrypt;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.symmetric.SymmetricAlgorithm;
import cn.hutool.crypto.symmetric.SymmetricCrypto;
import java.io.File;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.shodown.common.consts.Charsets;
import xyz.shodown.common.enums.EncodingEnum;
import xyz.shodown.common.util.basic.StringUtil;
import xyz.shodown.common.util.encrypt.CryptoFileUtil;

public class AesUtil
extends CryptoFileUtil {
    private static final Logger log = LoggerFactory.getLogger(AesUtil.class);
    private static final String DEFAULT_SECRET_KEY_AES = "54a52c09dab54cfa";
    private static final SymmetricCrypto AES = new SymmetricCrypto(SymmetricAlgorithm.AES, "54a52c09dab54cfa".getBytes());

    public static String encrypt(String key, String iv, String data) throws Exception {
        byte[] byteContent = data.getBytes();
        Cipher cipher = AesUtil.getCipherIns(key, iv, 1);
        byte[] encryptedBytes = cipher.doFinal(byteContent);
        return Base64.encodeUrlSafe((byte[])encryptedBytes);
    }

    public static String encrypt(String secretKey, String iv, String data, EncodingEnum encoding, Charset charset) throws Exception {
        byte[] byteContent = data.getBytes(charset);
        Cipher cipher = AesUtil.getCipherIns(secretKey, iv, 1);
        byte[] encryptedBytes = cipher.doFinal(byteContent);
        return StringUtil.encodeBytesToStr(encryptedBytes, encoding);
    }

    public static String decrypt(String key, String content, String iv) throws Exception {
        byte[] encryptedBytes = Base64.decode((CharSequence)content);
        Cipher cipher = AesUtil.getCipherIns(key, iv, 2);
        byte[] result = cipher.doFinal(encryptedBytes);
        return new String(result, Charsets.UTF8);
    }

    public static String decrypt(String secretKey, String iv, String encryptedData, EncodingEnum encoding, Charset charset) throws Exception {
        byte[] encryptedBytes;
        if (encoding == null || encoding == EncodingEnum.BASE64_URL_SAFE || encoding == EncodingEnum.BASE64) {
            encryptedBytes = Base64.decode((CharSequence)encryptedData);
        } else if (encoding == EncodingEnum.HEX) {
            encryptedBytes = HexUtil.decodeHex((String)encryptedData);
        } else {
            throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u7f16\u7801\u683c\u5f0f");
        }
        Cipher cipher = AesUtil.getCipherIns(secretKey, iv, 2);
        byte[] result = cipher.doFinal(encryptedBytes);
        return new String(result, charset);
    }

    public static String defaultEncrypt(String str) {
        return Base64.encodeUrlSafe((byte[])AES.encrypt(str));
    }

    public static String defaultDecrypt(String str) {
        return AES.decryptStr(Base64.decode((CharSequence)str));
    }

    public static File encryptFile(String key, String iv, File sourceFile, File result) throws Exception {
        Cipher cipher = AesUtil.getCipherIns(key, iv, 1);
        return AesUtil.streamCipherEncryptFile(sourceFile, cipher, result);
    }

    public static File decryptFile(String key, String iv, File encryptFile, File result) throws Exception {
        Cipher cipher = AesUtil.getCipherIns(key, iv, 2);
        return AesUtil.streamCipherDecryptFile(encryptFile, cipher, result);
    }

    private static Cipher getCipherIns(String key, String iv, int mode) throws NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] enCodeFormat = key.getBytes();
        SecretKeySpec secretKey = new SecretKeySpec(enCodeFormat, "AES");
        byte[] initParam = iv.getBytes();
        IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(mode, (Key)secretKey, ivParameterSpec);
        return cipher;
    }
}

