/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.encrypt;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import cn.hutool.crypto.KeyUtil;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import xyz.shodown.common.enums.EncodingEnum;

public class CryptoKeyGenerator {
    private static final String ALGORITHM_SM2 = "SM2";
    private static final String RSA = "RSA";
    private static final Integer DEFAULT_KEY_SIZE = 1024;

    public static KeyPair generateRsaKeyPair() {
        return CryptoKeyGenerator.getAsymmetricKeyPair(RSA, DEFAULT_KEY_SIZE);
    }

    public static KeyPair generateSm2KeyPair() {
        return CryptoKeyGenerator.getAsymmetricKeyPair(ALGORITHM_SM2, DEFAULT_KEY_SIZE);
    }

    public static KeyPair getAsymmetricKeyPair(String algorithm, int keySize) {
        return KeyUtil.generateKeyPair((String)algorithm, (int)keySize);
    }

    public static String strPrivateKey(KeyPair keyPair) {
        return CryptoKeyGenerator.strPrivateKey(keyPair, null);
    }

    public static String strPrivateKey(KeyPair keyPair, EncodingEnum encoding) {
        if (encoding == null || encoding == EncodingEnum.BASE64_URL_SAFE) {
            return Base64.encodeUrlSafe((byte[])keyPair.getPrivate().getEncoded());
        }
        if (encoding == EncodingEnum.BASE64) {
            return Base64.encode((byte[])keyPair.getPrivate().getEncoded());
        }
        if (encoding == EncodingEnum.HEX) {
            return HexUtil.encodeHexStr((byte[])keyPair.getPrivate().getEncoded());
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u7f16\u7801\u683c\u5f0f");
    }

    public static String strPublicKey(KeyPair keyPair) {
        return CryptoKeyGenerator.strPublicKey(keyPair, null);
    }

    public static String strPublicKey(KeyPair keyPair, EncodingEnum encoding) {
        if (encoding == null || encoding == EncodingEnum.BASE64_URL_SAFE) {
            return Base64.encodeUrlSafe((byte[])keyPair.getPublic().getEncoded());
        }
        if (encoding == EncodingEnum.BASE64) {
            return Base64.encode((byte[])keyPair.getPublic().getEncoded());
        }
        if (encoding == EncodingEnum.HEX) {
            return HexUtil.encodeHexStr((byte[])keyPair.getPublic().getEncoded());
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u7f16\u7801\u683c\u5f0f");
    }

    public static String generateAesSecretKey() {
        String key = UUID.randomUUID().toString();
        key = key.replace("-", "").substring(0, 16);
        return key;
    }

    public static void initSymmetricCipher(Cipher cipher, String secretKey, String iv, int mode, String algorithm, Charset charset) throws InvalidAlgorithmParameterException, InvalidKeyException {
        byte[] keyBytes = secretKey.getBytes(charset);
        SecretKeySpec secretKeySpec = new SecretKeySpec(keyBytes, algorithm);
        byte[] initParam = iv.getBytes(charset);
        IvParameterSpec ivParameterSpec = new IvParameterSpec(initParam);
        cipher.init(mode, (Key)secretKeySpec, ivParameterSpec);
    }
}

