/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.encrypt;

import cn.hutool.crypto.asymmetric.KeyType;
import cn.hutool.crypto.asymmetric.SM2;
import java.nio.charset.Charset;
import xyz.shodown.common.enums.EncodingEnum;
import xyz.shodown.common.util.basic.StringUtil;

public class SM2Util {
    public static String encrypt(String data, String publicKey, EncodingEnum encoding, Charset charset) throws Exception {
        SM2 sm2 = new SM2(null, publicKey);
        byte[] dataBytes = data.getBytes(charset);
        byte[] resBytes = sm2.encrypt(dataBytes, KeyType.PublicKey);
        return StringUtil.encodeBytesToStr(resBytes, encoding);
    }

    public static String decrypt(String encryptedData, String privateKey, EncodingEnum encoding, Charset charset) throws Exception {
        byte[] dataBytes = StringUtil.decodeStrToBytes(encryptedData, encoding);
        SM2 sm2 = new SM2(privateKey, null);
        return new String(sm2.decrypt(dataBytes, KeyType.PrivateKey), charset);
    }

    public static byte[] sign(String data, String privateKey, Charset charset) {
        SM2 sm2 = new SM2(privateKey, null);
        return sm2.sign(data.getBytes(charset));
    }

    public static String sign(String data, String privateKey, EncodingEnum encoding, Charset charset) {
        byte[] signBytes = SM2Util.sign(data, privateKey, charset);
        return StringUtil.encodeBytesToStr(signBytes, encoding);
    }

    public static boolean verify(String data, String publicKey, String sign, EncodingEnum encoding, Charset charset) {
        SM2 sm2 = new SM2(null, publicKey);
        byte[] dataBytes = data.getBytes(charset);
        byte[] signBytes = StringUtil.decodeStrToBytes(sign, encoding);
        return sm2.verify(dataBytes, signBytes);
    }
}

