/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.encrypt;

import cn.hutool.crypto.SecureUtil;
import cn.hutool.crypto.symmetric.SM4;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import xyz.shodown.common.consts.Charsets;
import xyz.shodown.common.enums.EncodingEnum;
import xyz.shodown.common.util.basic.StringUtil;
import xyz.shodown.common.util.encrypt.CryptoFileUtil;

public class SM4Util
extends CryptoFileUtil {
    public static String encrypt(String secretKey, String iv, String data, EncodingEnum encoding, Charset charset) throws Exception {
        SM4 sm4 = new SM4(SecureUtil.decode((String)secretKey));
        sm4.setIv(iv.getBytes(charset));
        byte[] encrypts = sm4.encrypt(data, charset);
        return StringUtil.encodeBytesToStr(encrypts, encoding);
    }

    public static File encryptFile(String secretKey, String iv, File sourceFile, File result) throws IOException, InvalidAlgorithmParameterException, InvalidKeyException {
        return SM4Util.encryptFile(secretKey, iv, sourceFile, result, Charsets.UTF8);
    }

    public static File encryptFile(String secretKey, String iv, File sourceFile, File result, Charset charset) throws IOException, InvalidAlgorithmParameterException, InvalidKeyException {
        SM4 sm4 = new SM4(SecureUtil.decode((String)secretKey));
        sm4.setIv(iv.getBytes(charset));
        byte[] fileBytes = SM4Util.flieToBytes(sourceFile);
        byte[] resBytes = sm4.encrypt(fileBytes);
        return SM4Util.outputFile(resBytes, result);
    }

    public static String decrypt(String secretKey, String iv, String encryptedData, EncodingEnum encoding, Charset charset) throws Exception {
        SM4 sm4 = new SM4(SecureUtil.decode((String)secretKey));
        sm4.setIv(iv.getBytes(charset));
        byte[] dataBytes = StringUtil.decodeStrToBytes(encryptedData, encoding);
        return new String(sm4.decrypt(dataBytes), charset);
    }

    public static File decryptFile(String secretKey, String iv, File encryptFile, File result, Charset charset) throws InvalidAlgorithmParameterException, InvalidKeyException, IOException {
        SM4 sm4 = new SM4(SecureUtil.decode((String)secretKey));
        sm4.setIv(iv.getBytes(charset));
        byte[] fileBytes = SM4Util.flieToBytes(encryptFile);
        byte[] resBytes = sm4.decrypt(fileBytes);
        return SM4Util.outputFile(resBytes, result);
    }

    public static File decryptFile(String secretKey, String iv, File encryptFile, File result) throws InvalidAlgorithmParameterException, InvalidKeyException, IOException {
        return SM4Util.decryptFile(secretKey, iv, encryptFile, result, Charsets.UTF8);
    }
}

