/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.io;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PropertiesLoaderUtils;
import org.springframework.util.ClassUtils;
import org.yaml.snakeyaml.Yaml;
import xyz.shodown.common.util.basic.StringUtil;

public class ResourceUtil
extends cn.hutool.core.io.resource.ResourceUtil {
    public static Map<String, String> readProperties(String fileName) throws IOException {
        Enumeration<URL> urls = Objects.requireNonNull(ClassUtils.getDefaultClassLoader()).getResources(fileName);
        HashMap<String, String> props = new HashMap<String, String>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            UrlResource resource = new UrlResource(url);
            Properties properties = PropertiesLoaderUtils.loadProperties((Resource)resource);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = StringUtil.toStr(entry.getKey()).trim();
                String value = StringUtil.toStr(entry.getValue()).trim();
                props.put(key, value);
            }
        }
        return props;
    }

    public static String readJarFile(Class<?> clazz) throws IOException {
        String exePath = clazz.getProtectionDomain().getCodeSource().getLocation().getPath();
        JarFile localJarFile = new JarFile(new File(exePath));
        StringBuilder sb = new StringBuilder();
        Enumeration<JarEntry> entries = localJarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            System.out.println(jarEntry.getName());
            String innerPath = jarEntry.getName();
            if (!innerPath.startsWith("conf")) continue;
            InputStream inputStream = clazz.getClassLoader().getResourceAsStream(innerPath);
            BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
            String line = "";
            while ((line = br.readLine()) != null) {
                sb.append(line);
                System.out.println(innerPath + "\u5185\u5bb9\u4e3a:" + line);
            }
        }
        return sb.toString();
    }

    public static Map<String, Object> readJsonFile(String filePath) {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            Map map = (Map)objectMapper.readValue(new File(filePath), Map.class);
            return map;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> readYaml(String filePath) throws FileNotFoundException {
        FileInputStream input = new FileInputStream(new File(filePath));
        Yaml yaml = new Yaml();
        Map object = (Map)yaml.load((InputStream)input);
        return object;
    }
}

