/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.io;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.shodown.common.response.Result;
import xyz.shodown.common.util.json.JsonUtil;

public class ResponseUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"exception");

    public static void out(ServletResponse response, Result<?> result) {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json");
        try (PrintWriter out = response.getWriter();){
            out.println(JsonUtil.objectToJson(result));
            if (out != null) {
                out.flush();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void out(HttpServletResponse response, String data, Integer code) {
        ResponseUtil.out((ServletResponse)response, Result.success(code, data));
    }
}

