/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.io;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.shodown.common.util.basic.StringUtil;

public class XssUtil {
    private static final Logger log = LoggerFactory.getLogger((String)"platform");

    public static boolean cleanSqlKeyWords(String paramValue) {
        if (StringUtil.isEmpty((CharSequence)paramValue)) {
            return false;
        }
        String value = paramValue;
        for (String keyword : SqlIllegalWords.NOT_ALLOWED_KEYWORDS) {
            boolean flag = paramValue.length() > keyword.length() + 2 && (StringUtil.containsIgnoreCase((CharSequence)paramValue, (CharSequence)(" " + keyword)) || StringUtil.containsIgnoreCase((CharSequence)paramValue, (CharSequence)(keyword + " ")) || StringUtil.containsIgnoreCase((CharSequence)paramValue, (CharSequence)(" " + keyword + " ")));
            if (!flag) continue;
            paramValue = StringUtil.replaceIgnoreCase((CharSequence)paramValue, (CharSequence)keyword, (CharSequence)"INVALID_");
            log.error("sql\u5df2\u8fc7\u6ee4\uff0c\u56e0\u4e3a\u53c2\u6570\u4e2d\u5305\u542b\u4e0d\u5141\u8bb8sql\u7684\u5173\u952e\u8bcd(" + keyword + ");\u53c2\u6570\uff1a" + value + ";\u8fc7\u6ee4\u540e\u7684\u53c2\u6570\uff1a" + paramValue);
            return true;
        }
        return false;
    }

    public static boolean cleanXss(String value) {
        if (StringUtil.isNotEmpty((CharSequence)value)) {
            String origin = value;
            StringBuilder sb = new StringBuilder();
            for (Pattern pattern : XssIllegalPattern.PATTERNS) {
                value = pattern.matcher(value).replaceAll("-");
            }
            if (!origin.equals(value)) {
                log.error("xss\u5df2\u88ab\u8fc7\u6ee4,\u8bf7\u6c42\u5305\u542b\u4e0d\u5141\u8bb8\u7684\u975e\u6cd5\u5185\u5bb9(" + sb.toString() + "),\u5185\u5bb9:" + origin + "\u8fc7\u6ee4\u540e\u7684\u5185\u5bb9:" + value);
                return true;
            }
        }
        return false;
    }

    public static boolean cleanXssAndSqlIllegals(String value) {
        boolean res = false;
        res = XssUtil.cleanXss(value);
        if (!res) {
            res = XssUtil.cleanSqlKeyWords(value);
        }
        return res;
    }

    private static class XssIllegalPattern {
        private static final Pattern SCRIPT_PATTERN = Pattern.compile("<script>(\\s*.*?)</script>", 2);
        private static final Pattern SCRIPT_PATTERN_END = Pattern.compile("</script(\\s*.*?)>", 2);
        private static final Pattern SCRIPT_PATTERN_START = Pattern.compile("<script(\\s*.*?)>", 42);
        private static final Pattern EVAL_PATTERN = Pattern.compile("eval\\((.*?)\\)", 42);
        private static final Pattern EXPRESSION_PATTERN = Pattern.compile("e\u00adxpression\\((.*?)\\)", 42);
        private static final Pattern JAVASCRIPT_PATTERN = Pattern.compile("javascript:", 2);
        private static final Pattern VB_SCRIPT_PATTERN = Pattern.compile("vbscript:", 2);
        private static final Pattern ONLOAD_PATTERN = Pattern.compile("onload(.*?)=", 42);
        private static final Pattern OTHER_PATTERN = Pattern.compile("<+.*(oncontrolselect|oncopy|oncut|ondataavailable|ondatasetchanged|ondatasetcomplete|ondblclick|ondeactivate|ondrag|ondragend|ondragenter|ondragleave|ondragover|ondragstart|ondrop|onerror|onerroupdate|onfilterchange|onfinish|onfocus|onfocusin|onfocusout|onhelp|onkeydown|onkeypress|onkeyup|onlayoutcomplete|onload|onlosecapture|onmousedown|onmouseenter|onmouseleave|onmousemove|onmousout|onmouseover|onmouseup|onmousewheel|onmove|onmoveend|onmovestart|onabort|onactivate|onafterprint|onafterupdate|onbefore|onbeforeactivate|onbeforecopy|onbeforecut|onbeforedeactivate|onbeforeeditocus|onbeforepaste|onbeforeprint|onbeforeunload|onbeforeupdate|onblur|onbounce|oncellchange|onchange|onclick|oncontextmenu|onpaste|onpropertychange|onreadystatechange|onreset|onresize|onresizend|onresizestart|onrowenter|onrowexit|onrowsdelete|onrowsinserted|onscroll|onselect|onselectionchange|onselectstart|onstart|onstop|onsubmit|onunload)+.*=+", 42);
        private static final List<Pattern> PATTERNS = new ArrayList<Pattern>();

        private XssIllegalPattern() {
        }

        static {
            PATTERNS.add(SCRIPT_PATTERN);
            PATTERNS.add(SCRIPT_PATTERN_END);
            PATTERNS.add(SCRIPT_PATTERN_START);
            PATTERNS.add(EVAL_PATTERN);
            PATTERNS.add(EXPRESSION_PATTERN);
            PATTERNS.add(JAVASCRIPT_PATTERN);
            PATTERNS.add(VB_SCRIPT_PATTERN);
            PATTERNS.add(ONLOAD_PATTERN);
            PATTERNS.add(OTHER_PATTERN);
        }
    }

    private static class SqlIllegalWords {
        private static final String KEY = "and|exec|execute|insert|where|sleep|like|select|delete|update|count|*|%|chr|mid|create|master|truncate|char|declare|;|or|//|/|-|--|+";
        private static final Set<String> NOT_ALLOWED_KEYWORDS = new HashSet<String>(0);
        private static final String INVALID = "INVALID_";

        private SqlIllegalWords() {
        }

        static {
            String[] keyStr = KEY.split("\\|");
            NOT_ALLOWED_KEYWORDS.addAll(Arrays.asList(keyStr));
        }
    }
}

