/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.protobuf;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import java.lang.reflect.Method;
import javax.validation.constraints.NotNull;
import xyz.shodown.common.util.json.JsonUtil;

public class ProtobufBeanUtil {
    private static final String NEW_BUILDER_METHOD = "newBuilder";

    public static <T> T fromProtobuf(@NotNull Message message, @NotNull Class<T> beanClz) throws InvalidProtocolBufferException {
        String json = JsonFormat.printer().print((MessageOrBuilder)message);
        return JsonUtil.jsonToBean(json, beanClz);
    }

    public static void toProtobuf(@NotNull Object bean, @NotNull Message.Builder builder) throws InvalidProtocolBufferException {
        String json = JsonUtil.objectToJson(bean);
        JsonFormat.parser().merge(json, builder);
    }

    public static <M extends Message> Message.Builder getBuilderByMsgClass(@NotNull Class<M> msgClass) {
        Method method = msgClass.getDeclaredMethod(NEW_BUILDER_METHOD, null);
        return (Message.Builder)method.invoke(null, null);
    }
}

