package xyz.shodown.common.util.basic;

import lombok.Data;

import java.util.function.Function;

/**
 * @ClassName: UserInfoUtil
 * @Description: 用户信息工具类
 * @Author: wangxiang
 * @Date: 2021/8/23 15:52
 */
public class UserInfoUtil {

    /**
     * 动态适配并获取用户代理对象
     * @return
     */
    private static <T> UserInfoDelegate<T> getDelegate(Class<T> clazz){
        if(clazz==null){
            return null;
        }
        // TODO:返回用户信息实现
        UserInfoDelegate<String> delegate = new UserInfoDelegate<>();
        if(clazz.isAssignableFrom(delegate.getUserInfo().getClass())){
            return (UserInfoDelegate<T>) delegate;
        }else {
            throw new RuntimeException();
        }
    }

    /**
     * 返回用户信息
     * @param userInfoType 用户对象实体类
     * @return 当前登录用户信息
     */
    public static <T> T getUserInfo(Class<T> userInfoType) {
        UserInfoDelegate<T> delegate = getDelegate(userInfoType);
        return delegate==null?null:delegate.getUserInfo();
    }

    /**
     * 返回用户某个属性
     * @param expression 属性的get方法
     * @param <T> 用户信息类
     * @param <R> 属性返回的类型
     * @return 用户某项信息
     */
    public static <T,R> R getUserDetail(Class<T> userInfoType,Function<T,R> expression){
        UserInfoDelegate<T> delegate = getDelegate(userInfoType);
        return delegate.getUserDetail(expression);
    }

    /**
     * 用户信息代理实体
     */
    @Data
    private static class UserInfoDelegate<T>{
        /**
         * 用户信息对象
         */
        private T userInfo;

        /**
         * 获取用户信息的某项属性,即用户的详细
         * @param expression 所需获取的某项细节的表达式
         * @return 返回用户的某个属性
         */
        public <R> R getUserDetail(Function<T,R> expression){
            return expression.apply(userInfo);
        }
    }
}
