package xyz.shodown.common.util.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;

import java.util.List;
import java.util.Map;

/**
 * @ClassName: JsonUtil
 * @Description: JSON工具类
 * @Author: wangxiang
 * @Date: 2021/2/4 15:41
 */
public class JsonUtil {

    private static Gson gson = null;

    static {
        if (gson == null) {
            GsonBuilder gsonBuilder = new GsonBuilder().serializeNulls();
            gson = gsonBuilder.create();
        }
    }

    /**
     * 对象转成json字符串
     * @param object 对象
     * @return json字符串
     */
    public static String objectToJson(Object object) {
        String json = null;
        if (gson != null) {
            json = gson.toJson(object);
        }
        return json;
    }

    /**
     * Json转成对象
     * @param json json字符串
     * @param cls 对象类
     * @param <T> 泛型
     * @return 对象
     */
    public static <T> T jsonToBean(String json, Class<T> cls) {
        T t = null;
        if (gson != null) {
            t = gson.fromJson(json, cls);
        }
        return t;
    }

    /**
     * json转成list<T>
     * @param json json字符串
     * @param cls 对象类
     * @param <T> 泛型
     * @return 对象list
     */
    public static <T> List<T> jsonToList(String json, Class<T> cls) {
        List<T> list = null;
        if (gson != null) {
            list = gson.fromJson(json, new TypeToken<List<T>>() {
            }.getType());
        }
        return list;
    }

    /**
     * json转成List<Map<String,T>>
     * @param json json字符串
     * @param <T> 泛型
     * @return List<Map<String,T>>
     */
    public static <T> List<Map<String, T>> jsonToListMaps(String json) {
        List<Map<String, T>> list = null;
        if (gson != null) {
            list = gson.fromJson(json, new TypeToken<List<Map<String, T>>>() {
            }.getType());
        }
        return list;
    }

    /**
     * json转成map
     * @param json json字符串
     * @param <T> 泛型
     * @return map
     */
    public static <T> Map<String, T> jsonToMap(String json) {
        Map<String, T> map = null;
        if (gson != null) {
            map = gson.fromJson(json, new TypeToken<Map<String, T>>() {
            }.getType());
        }
        return map;
    }

}
