/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.request;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RequestWrapper
extends HttpServletRequestWrapper {
    private String requestBody = null;
    HttpServletRequest req = null;

    public RequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        this.req = request;
        this.requestBody = this.getBodyString((ServletRequest)request);
    }

    public RequestWrapper(HttpServletRequest request, String requestBody) {
        super(request);
        this.requestBody = requestBody;
        this.req = request;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(this.requestBody));
    }

    public String getRequestBody() throws IOException {
        return this.requestBody;
    }

    public ServletInputStream getInputStream() throws IOException {
        return new ServletInputStream(){
            private InputStream in;
            {
                this.in = new ByteArrayInputStream(RequestWrapper.this.requestBody.getBytes(RequestWrapper.this.req.getCharacterEncoding()));
            }

            public boolean isFinished() {
                return false;
            }

            public boolean isReady() {
                return false;
            }

            public void setReadListener(ReadListener listener) {
            }

            public int read() throws IOException {
                return this.in.read();
            }
        };
    }

    public String getHeader(String name) {
        return super.getHeader(name);
    }

    private String getBodyString(ServletRequest request) throws IOException {
        StringBuilder sb = new StringBuilder();
        try (ServletInputStream inputStream = request.getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.forName("UTF-8")));){
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        }
        return sb.toString();
    }
}

