/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.request;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.shodown.common.util.io.XssUtil;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Logger log = LoggerFactory.getLogger((String)"platform");
    private String errMsg;

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
        this.errMsg = servletRequest.getRequestURI() + " \u8bf7\u6c42\u5305\u542b\u654f\u611f\u5b57\u7b26\u4e0e\u975e\u6cd5\u5185\u5bb9";
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        if (XssUtil.cleanXssAndSqlIllegals(value)) {
            log.error(this.errMsg);
        }
        return value;
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        boolean flag = false;
        for (int i = 0; i < count; ++i) {
            if (XssUtil.cleanXssAndSqlIllegals(values[i])) {
                flag = true;
            }
            encodedValues[i] = values[i];
        }
        if (flag) {
            log.error(this.errMsg);
        }
        return encodedValues;
    }

    public Map<String, String[]> getParameterMap() {
        Map values = super.getParameterMap();
        if (values == null) {
            return null;
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        boolean flag = false;
        for (String key : values.keySet()) {
            String encodedKey = new String(key);
            if (XssUtil.cleanXssAndSqlIllegals(encodedKey)) {
                log.error(this.errMsg);
                flag = true;
            }
            int count = ((String[])values.get(key)).length;
            String[] encodedValues = new String[count];
            for (int i = 0; i < count; ++i) {
                if (!flag && XssUtil.cleanXssAndSqlIllegals(((String[])values.get(key))[i])) {
                    log.error(this.errMsg);
                    flag = true;
                }
                encodedValues[i] = ((String[])values.get(key))[i];
            }
            result.put(encodedKey, encodedValues);
        }
        return result;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        if (XssUtil.cleanXssAndSqlIllegals(value)) {
            log.error(this.errMsg);
        }
        return value;
    }
}

