/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.response;

import java.io.Serializable;
import xyz.shodown.common.enums.ResponseEnum;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean success;
    private Serializable code;
    private String msg;
    private T data;

    public Result() {
    }

    public Result(Serializable code, boolean success, String msg, T data) {
        this.code = code;
        this.success = success;
        this.msg = msg;
        this.data = data;
    }

    public static <T> Result<T> success(T t) {
        Result<T> res = new Result<T>();
        res.setSuccess(true);
        res.setCode(Integer.valueOf(ResponseEnum.SUCCESS.getCode()));
        res.setMsg(ResponseEnum.SUCCESS.getMsg());
        res.setData(t);
        return res;
    }

    public static <T> Result<T> success(Serializable code, T t) {
        Result<T> r = new Result<T>();
        r.setSuccess(true);
        r.setCode(code);
        r.setData(t);
        return r;
    }

    public static <T> Result<T> success(String msg, T t) {
        Result<T> r = new Result<T>();
        r.setSuccess(true);
        r.setCode(Integer.valueOf(ResponseEnum.SUCCESS.getCode()));
        r.setMsg(msg);
        r.setData(t);
        return r;
    }

    public static <T> Result<T> success(Serializable code, String msg, T t) {
        Result<T> r = new Result<T>();
        r.setSuccess(true);
        r.setCode(code);
        r.setMsg(msg);
        r.setData(t);
        return r;
    }

    public static Result<?> success() {
        Result res = new Result();
        res.setSuccess(true);
        res.setCode(Integer.valueOf(ResponseEnum.SUCCESS.getCode()));
        res.setMsg(ResponseEnum.SUCCESS.getMsg());
        return res;
    }

    public static <T> Result<T> fail(Serializable code, String msg) {
        Result<T> r = new Result<T>();
        r.setCode(code);
        r.setMsg(msg);
        r.setSuccess(false);
        return r;
    }

    public static Result<?> fail(String msg) {
        return Result.fail(Integer.valueOf(ResponseEnum.NORMAL_EXCP.getCode()), msg);
    }

    public static Result<?> fail(ResponseEnum respEnum) {
        return Result.fail(Integer.valueOf(respEnum.getCode()), respEnum.getMsg());
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Serializable getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setCode(Serializable code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        Serializable this$code = this.getCode();
        Serializable other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        Serializable $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Result(success=" + this.isSuccess() + ", code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

