/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.encrypt;

import cn.hutool.core.util.HexUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PasswordUtil {
    private static final Logger log = LoggerFactory.getLogger(PasswordUtil.class);

    public static boolean isValidPassword(String password, String hashedPassword, String salt) throws NoSuchAlgorithmException {
        return hashedPassword.equalsIgnoreCase(PasswordUtil.encodePassword(password, salt));
    }

    public static String encodePassword(String password, String salt, int iterations) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-1");
        if (salt != null) {
            digest.reset();
            digest.update(salt.getBytes());
        }
        byte[] hashed = digest.digest(password.getBytes());
        if (iterations < 1) {
            iterations = 1;
        }
        for (int i = 1; i < iterations; ++i) {
            digest.reset();
            hashed = digest.digest(hashed);
        }
        return HexUtil.encodeHexStr((byte[])hashed);
    }

    public static String encodePassword(String password, String salt) throws NoSuchAlgorithmException {
        return PasswordUtil.encodePassword(password, salt, 1);
    }
}

