/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.encrypt;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.util.HexUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import xyz.shodown.common.enums.EncodingEnum;
import xyz.shodown.common.util.basic.StringUtil;

public class RsaUtil {
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final String RSA = "RSA";
    private static final String MD5withRSA = "MD5withRSA";

    public static PrivateKey getPrivateKey(String privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        byte[] decodedKey = Base64.decode((byte[])privateKey.getBytes());
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(decodedKey);
        return keyFactory.generatePrivate(keySpec);
    }

    public static PublicKey getPublicKey(String publicKey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        byte[] decodedKey = Base64.decode((byte[])publicKey.getBytes());
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(decodedKey);
        return keyFactory.generatePublic(keySpec);
    }

    public static String encrypt(String data, PublicKey publicKey) throws GeneralSecurityException, IOException {
        return Base64.encodeUrlSafe((byte[])RsaUtil.encrypt(data.getBytes(), publicKey));
    }

    public static String encrypt(String data, PublicKey publicKey, EncodingEnum encoding, Charset charset) throws GeneralSecurityException, IOException {
        byte[] encrypts = RsaUtil.encrypt(data.getBytes(charset), publicKey);
        return StringUtil.encodeBytesToStr(encrypts, encoding);
    }

    public static File encryptFile(File sourceFile, File resultFile, PublicKey publicKey) throws IOException, GeneralSecurityException {
        byte[] encryptBytes = RsaUtil.encrypt(RsaUtil.convertToBytes(sourceFile), publicKey);
        try (FileOutputStream out = new FileOutputStream(resultFile);){
            ((OutputStream)out).write(encryptBytes);
            out.flush();
            File file = resultFile;
            return file;
        }
    }

    public static byte[] encrypt(byte[] dataBytes, PublicKey publicKey) throws GeneralSecurityException, IOException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(1, publicKey);
        return RsaUtil.segmentalHandle(dataBytes, cipher, 1);
    }

    public static String decrypt(String data, PrivateKey privateKey, EncodingEnum encoding, Charset charset) throws GeneralSecurityException, IOException {
        byte[] dataBytes = StringUtil.decodeStrToBytes(data, encoding);
        return new String(RsaUtil.decrypt(dataBytes, privateKey), charset);
    }

    public static File decryptFile(File encryptFile, File resultFile, PrivateKey privateKey) throws IOException, GeneralSecurityException {
        byte[] decryptData = RsaUtil.decrypt(RsaUtil.convertToBytes(encryptFile), privateKey);
        try (FileOutputStream out = new FileOutputStream(resultFile);){
            ((OutputStream)out).write(decryptData);
            out.flush();
            File file = resultFile;
            return file;
        }
    }

    public static byte[] decrypt(byte[] dataBytes, PrivateKey privateKey) throws GeneralSecurityException, IOException {
        Cipher cipher = Cipher.getInstance(RSA);
        cipher.init(2, privateKey);
        return RsaUtil.segmentalHandle(dataBytes, cipher, 2);
    }

    public static byte[] sign(String data, PrivateKey privateKey, Charset charset) throws GeneralSecurityException {
        byte[] keyBytes = privateKey.getEncoded();
        PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PrivateKey key = keyFactory.generatePrivate(keySpec);
        Signature signature = Signature.getInstance(MD5withRSA);
        signature.initSign(key);
        signature.update(data.getBytes(charset));
        return signature.sign();
    }

    public static String sign(String data, PrivateKey privateKey, EncodingEnum encoding, Charset charset) throws GeneralSecurityException {
        byte[] signBytes = RsaUtil.sign(data, privateKey, charset);
        return StringUtil.encodeBytesToStr(signBytes, encoding);
    }

    public static boolean verify(String srcData, PublicKey publicKey, String sign, EncodingEnum encoding, Charset charset) throws GeneralSecurityException {
        if (encoding == null || encoding == EncodingEnum.BASE64 || encoding == EncodingEnum.BASE64_URL_SAFE) {
            return RsaUtil.verify(srcData.getBytes(charset), publicKey, Base64.decode((CharSequence)sign));
        }
        if (encoding == EncodingEnum.HEX) {
            return RsaUtil.verify(srcData.getBytes(charset), publicKey, HexUtil.decodeHex((String)sign));
        }
        throw new RuntimeException("\u6682\u4e0d\u652f\u6301\u5176\u4ed6\u7f16\u7801\u683c\u5f0f");
    }

    public static boolean verify(byte[] dataBytes, PublicKey publicKey, byte[] signBytes) throws GeneralSecurityException {
        byte[] keyBytes = publicKey.getEncoded();
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(keyBytes);
        KeyFactory keyFactory = KeyFactory.getInstance(RSA);
        PublicKey key = keyFactory.generatePublic(keySpec);
        Signature signature = Signature.getInstance(MD5withRSA);
        signature.initVerify(key);
        signature.update(dataBytes);
        return signature.verify(signBytes);
    }

    private static byte[] segmentalHandle(byte[] dataBytes, Cipher cipher, int mode) throws GeneralSecurityException, IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            int inputLen = dataBytes.length;
            int offset = 0;
            int i = 0;
            while (inputLen - offset > 0) {
                int block = 117;
                if (2 == mode) {
                    block = 128;
                }
                byte[] cache = inputLen - offset > block ? cipher.doFinal(dataBytes, offset, block) : cipher.doFinal(dataBytes, offset, inputLen - offset);
                out.write(cache, 0, cache.length);
                offset = ++i * block;
            }
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] convertToBytes(File file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

