/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.common.util.io;

import cn.hutool.extra.servlet.ServletUtil;
import cn.hutool.http.ContentType;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import xyz.shodown.common.util.json.JsonUtil;

public class HttpUtil
extends cn.hutool.http.HttpUtil {
    public static String getRequestParams(HttpServletRequest request) {
        Map params = request.getParameterMap();
        HashMap<String, String> json = new HashMap<String, String>();
        for (String key : params.keySet()) {
            String[] values = (String[])params.get(key);
            if (values.length <= 0) continue;
            json.put(key, values[0]);
        }
        return JsonUtil.objectToJson(json);
    }

    public static void writeResponse(ServletResponse response, String responseString) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType(ContentType.JSON.toString());
        PrintWriter out = response.getWriter();
        out.print(responseString);
        out.flush();
        out.close();
    }

    public static void addCookie(HttpServletResponse response, Cookie cookie) {
        ServletUtil.addCookie((HttpServletResponse)response, (Cookie)cookie);
    }

    public static void addCookie(HttpServletResponse response, String name, String value) {
        ServletUtil.addCookie((HttpServletResponse)response, (String)name, (String)value);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String path, String domain) {
        ServletUtil.addCookie((HttpServletResponse)response, (String)name, (String)value, (int)maxAgeInSeconds, (String)path, (String)domain);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds, String domain) {
        ServletUtil.addCookie((HttpServletResponse)response, (String)name, (String)value, (int)maxAgeInSeconds, (String)"/", (String)domain);
    }

    public static void addCookie(HttpServletResponse response, String name, String value, int maxAgeInSeconds) {
        ServletUtil.addCookie((HttpServletResponse)response, (String)name, (String)value, (int)maxAgeInSeconds);
    }

    public static Cookie getCookie(HttpServletRequest request, String name) {
        return ServletUtil.getCookie((HttpServletRequest)request, (String)name);
    }

    public static String getCookieContent(HttpServletRequest request, String name) {
        Cookie cookie = HttpUtil.getCookie(request, name);
        if (cookie != null) {
            return cookie.getValue();
        }
        return null;
    }

    public static void removeCookie(String name, String domain, HttpServletRequest request, HttpServletResponse response) {
        String cookieVal = HttpUtil.getCookieContent(request, name);
        if (cookieVal != null) {
            HttpUtil.addCookie(response, name, null, 0, "/", domain);
        }
    }

    public static HttpServletRequest getHttpServletRequest() {
        return ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
    }

    public static String getDomain() {
        HttpServletRequest request = HttpUtil.getHttpServletRequest();
        StringBuffer url = request.getRequestURL();
        return url.delete(url.length() - request.getRequestURI().length(), url.length()).toString();
    }
}

