/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.flow.evaluator;

import xyz.shodown.flow.entity.EvalResult;
import xyz.shodown.flow.evaluator.Evaluator;
import xyz.shodown.flow.navigator.NavigatorAdapter;

public abstract class EvaluatorAdapter<T, Y, N>
implements Evaluator<T> {
    private NavigatorAdapter<Y, ?> positiveNav;
    private NavigatorAdapter<N, ?> negativeNav;

    public void exec(T t) throws Exception {
        EvalResult<Y, N> evalResult = this.evaluate(t);
        boolean flag = evalResult.isResult();
        if (flag) {
            if (this.positiveNav != null) {
                Y data = evalResult.getPositiveData();
                this.positiveProcess(this.positiveNav, data);
            }
        } else if (this.negativeNav != null) {
            N data = evalResult.getNegativeData();
            this.negativeProcess(this.negativeNav, data);
        }
    }

    private void positiveProcess(NavigatorAdapter<Y, ?> nav, Y t) throws Exception {
        nav.process(t);
    }

    private void negativeProcess(NavigatorAdapter<N, ?> nav, N t) throws Exception {
        nav.process(t);
    }

    public NavigatorAdapter<Y, ?> getPositiveNav() {
        return this.positiveNav;
    }

    public void setPositiveNav(NavigatorAdapter<Y, ?> positiveNav) {
        this.positiveNav = positiveNav;
    }

    public NavigatorAdapter<N, ?> getNegativeNav() {
        return this.negativeNav;
    }

    public void setNegativeNav(NavigatorAdapter<N, ?> negativeNav) {
        this.negativeNav = negativeNav;
    }

    public abstract EvalResult<Y, N> evaluate(T var1) throws Exception;
}

