/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.flow.navigator;

import xyz.shodown.flow.direction.DirectionAdapter;
import xyz.shodown.flow.evaluator.EvaluatorAdapter;
import xyz.shodown.flow.navigator.Navigator;

public abstract class NavigatorAdapter<T, R>
implements Navigator<R> {
    private DirectionAdapter<R> direction;
    private EvaluatorAdapter<R, ?, ?> evaluator;

    public void process(T t) throws Exception {
        R r = this.doProcess(t);
        if (this.direction != null) {
            this.direction.run(r);
            return;
        }
        if (this.evaluator != null) {
            this.evaluator.exec(r);
        }
    }

    public DirectionAdapter<R> getDirection() {
        return this.direction;
    }

    public void setDirection(DirectionAdapter<R> direction) {
        this.direction = direction;
    }

    public EvaluatorAdapter<R, ?, ?> getEvaluator() {
        return this.evaluator;
    }

    public void setEvaluator(EvaluatorAdapter<R, ?, ?> evaluator) {
        this.evaluator = evaluator;
    }

    public abstract R doProcess(T var1) throws Exception;
}

