/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.grpc.client;

import com.google.protobuf.Message;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.stub.AbstractBlockingStub;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.InitializingBean;
import xyz.shodown.common.util.basic.StringUtil;
import xyz.shodown.common.util.protobuf.ProtobufBeanUtil;
import xyz.shodown.grpc.annotaion.GrpcClient;
import xyz.shodown.grpc.entity.Connection;
import xyz.shodown.grpc.exception.ShodownGrpcException;

public abstract class GrpcClientProxy
implements InitializingBean {
    private Connection connection;
    private ManagedChannel channel;

    private ManagedChannel getChannel(String host, Integer port) {
        this.channel = ManagedChannelBuilder.forAddress((String)host, (int)port).usePlaintext().build();
        return this.channel;
    }

    private void shutdown() throws InterruptedException {
        if (!this.channel.isShutdown()) {
            this.channel.shutdown().awaitTermination((long)this.connection.getCloseSeconds().intValue(), TimeUnit.SECONDS);
        }
    }

    private GrpcClientProxy connect() {
        if (this.connection == null) {
            throw new ShodownGrpcException("\u672a\u914d\u7f6eConnection,\u8bf7\u5148\u914d\u7f6e\u8fde\u63a5\u53c2\u6570");
        }
        Integer port = this.connection.getPort();
        String host = this.connection.getHost();
        if (port == null || port == 0) {
            throw new ShodownGrpcException("\u670d\u52a1\u7684\u7aef\u53e3\u9700\u8981\u914d\u7f6e");
        }
        if (StringUtil.isBlank((CharSequence)host)) {
            throw new ShodownGrpcException("\u670d\u52a1\u7684\u5730\u5740\u9700\u8981\u914d\u7f6e");
        }
        this.channel = this.getChannel(host, port);
        return this;
    }

    public <R extends Message> R invokeServiceBlocking(@NotNull String serviceMethod, Message ... messages) {
        Method[] methods;
        if (this.channel == null || this.channel.isShutdown() || this.channel.isTerminated()) {
            this.connect();
        }
        Object blockingStub = this.getBlockingStub(this.channel);
        for (Method method : methods = blockingStub.getClass().getDeclaredMethods()) {
            String name = method.getName();
            if (!name.equals(serviceMethod)) continue;
            Message r = (Message)method.invoke(blockingStub, (Object[])messages);
            this.shutdown();
            return (R)r;
        }
        this.shutdown();
        return null;
    }

    public <T> T invokeServiceBlocking(@NotNull Class<T> resultClass, @NotNull String serviceMethod, Message ... messages) {
        if (this.channel == null || this.channel.isShutdown() || this.channel.isTerminated()) {
            this.connect();
        }
        return this.responseResult((Message)this.invokeServiceBlocking(serviceMethod, messages), resultClass);
    }

    public abstract <BS extends AbstractBlockingStub> BS getBlockingStub(ManagedChannel var1);

    public Connection initConnection() {
        return this.connection;
    }

    public <T> T responseResult(@NotNull Message protoResultBean, @NotNull Class<T> resultClass) {
        return (T)ProtobufBeanUtil.fromProtobuf((Message)protoResultBean, resultClass);
    }

    public Message requestParam(@NotNull Object param, @NotNull Message.Builder builder) {
        ProtobufBeanUtil.toProtobuf((Object)param, (Message.Builder)builder);
        return builder.build();
    }

    public <M extends Message> Message requestParam(@NotNull Object param, @NotNull Class<M> protoClass) {
        Message.Builder builder = ProtobufBeanUtil.getBuilderByMsgClass(protoClass);
        ProtobufBeanUtil.toProtobuf((Object)param, (Message.Builder)builder);
        return builder.build();
    }

    public void afterPropertiesSet() throws Exception {
        GrpcClient annotation = this.getClass().getAnnotation(GrpcClient.class);
        if (annotation != null && this.connection == null) {
            this.connection = new Connection();
            this.connection.setHost(annotation.host());
            this.connection.setPort(annotation.port());
            this.connection.setCloseSeconds(annotation.closeSeconds());
        }
    }
}

