/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.grpc.server;

import cn.hutool.extra.spring.SpringUtil;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import java.io.IOException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.shodown.grpc.annotaion.GrpcService;

public class GrpcServerLauncher {
    private static final Logger log = LoggerFactory.getLogger(GrpcServerLauncher.class);
    private static ThreadLocal<Server> serverThreadLocal = new ThreadLocal();

    private static void grpcStart(Map<String, Object> grpcServiceBeanMap, Integer port) {
        try {
            ServerBuilder serverBuilder = ServerBuilder.forPort((int)port);
            for (Object bean : grpcServiceBeanMap.values()) {
                serverBuilder.addService((BindableService)bean);
                log.info(bean.getClass().getSimpleName() + " is regist in Spring Boot");
            }
            Server server = serverBuilder.build().start();
            log.info("grpc server is started at " + port);
            server.awaitTermination();
            serverThreadLocal.set(server);
            Runtime.getRuntime().addShutdownHook(new Thread(() -> GrpcServerLauncher.grpcStop()));
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private static void grpcStop() {
        if (serverThreadLocal.get() != null) {
            serverThreadLocal.get().shutdownNow();
            serverThreadLocal.remove();
        }
    }

    public static void launch(Integer port) {
        Map grpcServiceBeanMap = SpringUtil.getApplicationContext().getBeansWithAnnotation(GrpcService.class);
        GrpcServerLauncher.grpcStart(grpcServiceBeanMap, port);
    }
}

