/*
 * Decompiled with CFR 0.152.
 */
package xyz.shodown.jpa.components;

import java.lang.reflect.Field;
import java.util.Iterator;
import org.hibernate.boot.Metadata;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Selectable;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.shodown.jpa.annotation.Comment;

public class CommentIntegrator
implements Integrator {
    private static final Logger log = LoggerFactory.getLogger((String)"platform");
    public static final CommentIntegrator INSTANCE = new CommentIntegrator();

    public void integrate(Metadata metadata, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        this.processComment(metadata);
    }

    public void disintegrate(SessionFactoryImplementor sessionFactoryImplementor, SessionFactoryServiceRegistry sessionFactoryServiceRegistry) {
    }

    private void processComment(Metadata metadata) {
        for (PersistentClass persistentClass : metadata.getEntityBindings()) {
            Property identifierProperty;
            Class clz = persistentClass.getMappedClass();
            if (clz.isAnnotationPresent(Comment.class)) {
                Comment comment = clz.getAnnotation(Comment.class);
                persistentClass.getTable().setComment(comment.value());
            }
            if ((identifierProperty = persistentClass.getIdentifierProperty()) != null) {
                this.fieldComment(persistentClass, identifierProperty.getName());
            } else {
                Component component = persistentClass.getIdentifierMapper();
                if (component != null) {
                    Iterator iterator = component.getPropertyIterator();
                    while (iterator.hasNext()) {
                        this.fieldComment(persistentClass, ((Property)iterator.next()).getName());
                    }
                }
            }
            Iterator iterator = persistentClass.getPropertyIterator();
            while (iterator.hasNext()) {
                this.fieldComment(persistentClass, ((Property)iterator.next()).getName());
            }
        }
    }

    private void fieldComment(PersistentClass persistentClass, String columnName) {
        Field field = this.findFieldRecursively(persistentClass.getMappedClass(), columnName);
        if (field == null) {
            return;
        }
        if (field.isAnnotationPresent(Comment.class)) {
            String comment = field.getAnnotation(Comment.class).value();
            String sqlColumnName = ((Selectable)persistentClass.getProperty(columnName).getValue().getColumnIterator().next()).getText();
            Iterator columnIterator = persistentClass.getTable().getColumnIterator();
            while (columnIterator.hasNext()) {
                Column column = (Column)columnIterator.next();
                if (!sqlColumnName.equalsIgnoreCase(column.getName())) continue;
                column.setComment(comment);
                break;
            }
        }
    }

    private Field findFieldRecursively(Class<?> clazz, String cloumnName) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(cloumnName);
            }
            catch (NoSuchFieldException | SecurityException ignored) {
                Class<?> superclass = clazz.getSuperclass();
                if (superclass == null) break block2;
                field = this.findFieldRecursively(superclass, cloumnName);
            }
        }
        return field;
    }
}

