/*
 * Decompiled with CFR 0.152.
 */
package xyz.wirklich.astro.sun;

import java.time.ZonedDateTime;
import xyz.wirklich.astro.time.JulianDay;

public class SolarLocation {
    JulianDay jd;
    double latitude = 0.0;
    double longitude = 0.0;

    public SolarLocation(double latitude, double longitude, JulianDay jd) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.jd = jd;
    }

    public SolarLocation(double latitude, double longitude, ZonedDateTime date) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.jd = new JulianDay(date);
    }

    public double geomagneticMeanLongitudeSun() {
        double jdC = this.jd.getJulianCenturyJ2000();
        return (280.46646 + jdC * (36000.76983 + jdC * 3.032E-4)) % 360.0;
    }

    public double geomagneticMeanAnomalySun() {
        double jdC = this.jd.getJulianCenturyJ2000();
        return 357.52911 + jdC * (35999.05029 - 1.537E-4 * jdC);
    }

    public double eccentricityEarthOrbit() {
        double jdC = this.jd.getJulianCenturyJ2000();
        return 0.016708634 - jdC * (4.2037E-5 + 1.267E-7 * jdC);
    }

    public double sunEqOfCtr() {
        double jdC = this.jd.getJulianCenturyJ2000();
        return Math.sin(Math.toRadians(this.geomagneticMeanAnomalySun())) * (1.914602 - jdC * (0.004817 + 1.4E-5 * jdC)) + Math.sin(Math.toRadians(2.0 * this.geomagneticMeanAnomalySun())) * (0.019993 - 1.01E-4 * jdC) + Math.sin(Math.toRadians(3.0 * this.geomagneticMeanAnomalySun())) * 2.89E-4;
    }

    public double sunTrueLong() {
        return this.sunEqOfCtr() + this.geomagneticMeanLongitudeSun();
    }

    public double sunTrueAnomaly() {
        return this.sunEqOfCtr() + this.geomagneticMeanAnomalySun();
    }

    public double sunRadVector() {
        double ecc = this.eccentricityEarthOrbit();
        return 1.000001018 * (1.0 - ecc * ecc) / (1.0 + ecc * Math.cos(Math.toRadians(this.sunTrueAnomaly())));
    }

    public double sunApparentLongitude() {
        double jdC = this.jd.getJulianCenturyJ2000();
        return this.sunTrueLong() - 0.00569 - 0.00478 * Math.sin(Math.toRadians(125.04 - 1934.136 * jdC));
    }

    public double meanObliquEcliptic() {
        double jdC = this.jd.getJulianCenturyJ2000();
        return 23.0 + (26.0 + (21.448 - jdC * (46.815 + jdC * (5.9E-4 - jdC * 0.001813))) / 60.0) / 60.0;
    }

    public double obliqueCorrected() {
        double jdC = this.jd.getJulianCenturyJ2000();
        return this.meanObliquEcliptic() + 0.00256 * Math.cos(Math.toRadians(125.04 - 1934.136 * jdC));
    }

    public double sunRtAscend() {
        double appLong = Math.toRadians(this.sunApparentLongitude());
        double obliq = Math.toRadians(this.obliqueCorrected());
        return Math.toDegrees(Math.atan2(Math.cos(obliq) * Math.sin(appLong), Math.cos(appLong)));
    }

    public double sunDeclination() {
        return Math.toDegrees(Math.asin(Math.sin(Math.toRadians(this.obliqueCorrected())) * Math.sin(Math.toRadians(this.sunApparentLongitude()))));
    }

    private double varY() {
        return Math.pow(Math.tan(Math.toRadians(this.obliqueCorrected() / 2.0)), 2.0);
    }

    private double eqOfTime() {
        double geomMeanLong = Math.toRadians(this.geomagneticMeanLongitudeSun());
        double ecc = this.eccentricityEarthOrbit();
        double geoMeanAnom = Math.toRadians(this.geomagneticMeanAnomalySun());
        double vY = this.varY();
        return 4.0 * Math.toDegrees(vY * Math.sin(2.0 * geomMeanLong) - 2.0 * ecc * Math.sin(geoMeanAnom) + 4.0 * ecc * vY * Math.sin(geoMeanAnom) * Math.cos(2.0 * geomMeanLong) - 0.5 * vY * vY * Math.sin(4.0 * geomMeanLong) - 1.25 * ecc * ecc * Math.sin(2.0 * geoMeanAnom));
    }

    public double haSunrise() {
        return Math.toDegrees(Math.acos(Math.cos(Math.toRadians(90.833)) / (Math.cos(Math.toRadians(this.getLatitude())) * Math.cos(Math.toRadians(this.sunDeclination()))) - Math.tan(Math.toRadians(this.getLatitude())) * Math.tan(Math.toRadians(this.sunDeclination()))));
    }

    public double solarNoon() {
        double longi = this.getLongitude();
        double eqT = this.eqOfTime();
        return (720.0 - 4.0 * longi - eqT) / 1440.0;
    }

    public double sunrise() {
        return this.solarNoon() - this.haSunrise() * 4.0 / 1440.0;
    }

    public double sunset() {
        return this.solarNoon() + this.haSunrise() * 4.0 / 1440.0;
    }

    public double sunlightDuration() {
        return this.haSunrise() * 8.0;
    }

    private double getTimePastMidnight() {
        double T = this.jd.getJd() + 0.5;
        return T - Math.floor(T);
    }

    public double trueSolarTime() {
        return (this.getTimePastMidnight() * 1440.0 + this.eqOfTime() + 4.0 * this.getLongitude()) % 1440.0;
    }

    public double hourAngle() {
        double tt = this.trueSolarTime();
        return tt / 4.0 < 0.0 ? tt / 4.0 + 180.0 : tt / 4.0 - 180.0;
    }

    public double solarZenithAngle() {
        return Math.toDegrees(Math.acos(Math.sin(Math.toRadians(this.getLatitude())) * Math.sin(Math.toRadians(this.sunDeclination())) + Math.cos(Math.toRadians(this.getLatitude())) * Math.cos(Math.toRadians(this.sunDeclination())) * Math.cos(Math.toRadians(this.hourAngle()))));
    }

    public double solarElevation() {
        return 90.0 - this.solarZenithAngle();
    }

    public double refractionCorrection() {
        double elevation = this.solarElevation();
        if (elevation > 85.0) {
            return 0.0;
        }
        if (elevation > 5.0) {
            return (58.1 / Math.tan(Math.toRadians(elevation)) - 0.07 / Math.pow(Math.tan(Math.toRadians(elevation)), 3.0) + 8.6E-5 / Math.pow(Math.tan(Math.toRadians(elevation)), 5.0)) / 3600.0;
        }
        if (elevation > -0.575) {
            return (1735.0 + elevation * (-518.2 + elevation * (103.4 + elevation * (-12.79 + elevation * 0.711)))) / 3600.0;
        }
        return -20.772 / Math.tan(Math.toRadians(elevation)) / 3600.0;
    }

    public double solarElevationCorrected() {
        return this.solarElevation() + this.refractionCorrection();
    }

    public double solarAzimuth() {
        double lat = Math.toRadians(this.getLatitude());
        double zenith = Math.toRadians(this.solarZenithAngle());
        double decl = Math.toRadians(this.sunDeclination());
        if (this.hourAngle() > 0.0) {
            return (Math.toDegrees(Math.acos((Math.sin(lat) * Math.cos(zenith) - Math.sin(decl)) / (Math.cos(lat) * Math.sin(zenith)))) + 180.0) % 360.0;
        }
        return (540.0 - Math.toDegrees(Math.acos((Math.sin(lat) * Math.cos(zenith) - Math.sin(decl)) / (Math.cos(lat) * Math.sin(zenith))))) % 360.0;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }
}

