/*
 * Decompiled with CFR 0.152.
 */
package bbd.jportal2.generators.FreeMarker;

import bbd.jportal2.BaseGenerator;
import bbd.jportal2.Database;
import bbd.jportal2.Flag;
import bbd.jportal2.ITemplateBasedPostProcessor;
import bbd.jportal2.ITemplateBasedSIProcessor;
import bbd.jportal2.Main;
import bbd.jportal2.Proc;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.TemplateHashModel;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreeMarker
extends BaseGenerator
implements ITemplateBasedSIProcessor,
ITemplateBasedPostProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Main.class);

    public FreeMarker() {
        super(FreeMarker.class);
    }

    @Override
    public String description() {
        return "Generate according to a given FreeMarker template.";
    }

    @Override
    public String documentation() {
        return "Generate according to a given FreeMarker template. Usage is TODO";
    }

    @Override
    public Vector<Flag> getFlags() {
        return new Vector<Flag>();
    }

    @Override
    public void generateTemplate(final Database database, final String templateBaseDir, final String generatorName, final File outputDirectory) throws Exception {
        this.getGeneratedOutputFiles().setGeneratorName(generatorName);
        final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**/*.ftl");
        final Path fullGeneratorPath = Paths.get(templateBaseDir, generatorName);
        Files.walkFileTree(Paths.get(fullGeneratorPath.toString(), new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (matcher.matches(file)) {
                    Path pathToTemplateBaseDir = Paths.get(templateBaseDir, new String[0]);
                    Path relativePathToFTL = fullGeneratorPath.relativize(file);
                    try {
                        FreeMarker.this.GenerateSingleFTLFile(fullGeneratorPath.toString(), generatorName, relativePathToFTL.toString(), outputDirectory, database);
                    }
                    catch (Exception te) {
                        throw new RuntimeException(te);
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private Configuration configure(File templateDir) throws IOException {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_23);
        FileTemplateLoader ftl1 = new FileTemplateLoader(templateDir);
        FileTemplateLoader ftl2 = new FileTemplateLoader(new File(Paths.get("", new String[0]).toAbsolutePath().toString()));
        ClassTemplateLoader ctl1 = new ClassTemplateLoader(FreeMarker.class, this.getSIProcessorTemplateFilesLocation().toString());
        ClassTemplateLoader ctl2 = new ClassTemplateLoader(FreeMarker.class, this.getPostProcessorTemplateFilesLocation().toString());
        MultiTemplateLoader mtl = new MultiTemplateLoader(new TemplateLoader[]{ftl1, ctl1, ctl2, ftl2});
        cfg.setTemplateLoader(mtl);
        cfg.setDefaultEncoding("UTF-8");
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        cfg.setLogTemplateExceptions(false);
        return cfg;
    }

    private void GenerateSingleFTLFile(String templateBaseDir, String generatorName, String templateName, File outputDir, Database database) throws TemplateException, IOException, ClassNotFoundException {
        Configuration cfg = this.configure(new File(templateBaseDir));
        HashMap<String, Serializable> root = new HashMap<String, Serializable>();
        root.put("database", database);
        root.put("table", database.tables.get(0));
        DefaultObjectWrapperBuilder builder = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_28);
        builder.setUseModelCache(true);
        builder.setExposeFields(true);
        builder.setExposureLevel(0);
        DefaultObjectWrapper wrapper = builder.build();
        root.put("STATICS", new HashMap());
        TemplateHashModel staticModels = wrapper.getStaticModels();
        ((HashMap)root.get("STATICS")).put("Database", staticModels.get("bbd.jportal2.Database"));
        ((HashMap)root.get("STATICS")).put("Table", staticModels.get("bbd.jportal2.Table"));
        ((HashMap)root.get("STATICS")).put("Field", staticModels.get("bbd.jportal2.Field"));
        ((HashMap)root.get("STATICS")).put("PlaceHolder", staticModels.get("bbd.jportal2.PlaceHolder"));
        root.put("ENUMS", new HashMap());
        TemplateHashModel enumModels = wrapper.getEnumModels();
        ((HashMap)root.get("ENUMS")).put("Database", enumModels.get("bbd.jportal2.Database"));
        ((HashMap)root.get("ENUMS")).put("Table", enumModels.get("bbd.jportal2.Table"));
        ((HashMap)root.get("ENUMS")).put("Field", enumModels.get("bbd.jportal2.Field"));
        ((HashMap)root.get("ENUMS")).put("PlaceHolder", enumModels.get("bbd.jportal2.PlaceHolder"));
        Path templateRelativePath = Paths.get(templateName, new String[0]);
        String strRelativePath = templateRelativePath.toString();
        HashSet<String> doneFiles = new HashSet<String>();
        for (Proc proc : database.tables.get((int)0).procs) {
            root.put("proc", proc);
            if (strRelativePath.endsWith(".ftl")) {
                strRelativePath = strRelativePath.substring(0, strRelativePath.length() - 4);
            }
            String destFileName = strRelativePath;
            Template fileNameTemplate = new Template("fileNameTemplate_" + templateRelativePath.toString(), new StringReader(destFileName), cfg);
            StringWriter fileNameOut = new StringWriter();
            fileNameTemplate.process(root, fileNameOut);
            destFileName = ((Object)fileNameOut).toString();
            if (doneFiles.contains(destFileName)) continue;
            Path fullDestinationFile = Paths.get(outputDir.toString(), destFileName);
            fullDestinationFile.getParent().toFile().mkdirs();
            Template temp = cfg.getTemplate(templateName);
            logger.info("\t [{}]: Generating [{}]", (Object)generatorName, (Object)fullDestinationFile.toString());
            doneFiles.add(destFileName);
            PrintWriter outData = this.openOutputFileForGeneration(generatorName, fullDestinationFile.toString());
            Throwable throwable = null;
            try {
                temp.process(root, outData);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (outData == null) continue;
                if (throwable != null) {
                    try {
                        outData.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                outData.close();
            }
        }
    }

    private Path findTemplateDirectory(String templateBaseDir, String generatorName) throws Exception {
        Path template_generatorsPath;
        Path templateFilesLocation = Paths.get(templateBaseDir, generatorName);
        if (Files.exists(templateFilesLocation, new LinkOption[0])) {
            return templateFilesLocation;
        }
        URI uri = this.getClass().getResource(templateFilesLocation.toString().replace(File.separator, "/")).toURI();
        if (uri.getScheme().equals("jar")) {
            FileSystem fileSystem = FileSystems.newFileSystem(uri, Collections.emptyMap());
            template_generatorsPath = fileSystem.getPath(templateFilesLocation.toString(), new String[0]);
        } else {
            template_generatorsPath = Paths.get(uri);
        }
        return template_generatorsPath;
    }
}

