/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Set;
import net.sf.extcos.filter.ChainedConnector;
import net.sf.extcos.filter.Connector;
import net.sf.extcos.filter.ImmediateConnector;
import net.sf.extcos.internal.AbstractFilterObjectsBuilder;
import net.sf.extcos.internal.BuildSupport;
import net.sf.extcos.selector.TypeFilter;
import net.sf.extcos.selector.TypeFilterJunction;
import net.sf.extcos.util.Assert;

public abstract class AbstractFilterObjectsJunctionBuilder
extends AbstractFilterObjectsBuilder {
    private final BuildSupport buildSupport = new BuildSupport();

    @Override
    public void buildFilterObjects(TypeFilter filter, Connector parent) {
        Assert.notNull(filter, Assert.iae());
        Assert.isTrue(filter instanceof TypeFilterJunction, Assert.iae());
        Assert.notNull(parent, Assert.iae());
        if (!(parent instanceof ImmediateConnector) && this.buildContext.isRegistered(filter)) {
            this.buildContext.getConnector(filter).merge(parent);
        } else {
            Set<TypeFilter> children = ((TypeFilterJunction)filter).getTypeFilters();
            ChainedConnector connector = this.getConnector();
            connector.setChildCount(children.size());
            connector.setParentConnector(parent);
            for (TypeFilter child : children) {
                this.buildSupport.buildFilterObjects(child, connector);
            }
            this.buildContext.register(filter, connector);
        }
    }

    protected abstract ChainedConnector getConnector();
}

