/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import net.sf.extcos.exception.ConcurrentInspectionException;
import net.sf.extcos.filter.ResourceMatcher;
import net.sf.extcos.resource.Resource;
import net.sf.extcos.selector.annotation.AnnotationArgument;
import net.sf.extcos.spi.AnnotationMetadata;
import net.sf.extcos.util.Assert;

public class AnnotationArgumentResourceMatcher
implements ResourceMatcher {
    private final AnnotationArgument annotationArgument;

    public AnnotationArgumentResourceMatcher(AnnotationArgument annotationArgument) {
        Assert.notNull(annotationArgument, IllegalArgumentException.class, "annotationArgument must not be null");
        this.annotationArgument = annotationArgument;
    }

    @Override
    public boolean matches(Resource resource) throws ConcurrentInspectionException {
        Assert.notNull(resource, IllegalArgumentException.class);
        AnnotationMetadata metadata = resource.getAnnotationMetadata(this.annotationArgument.getAnnotation());
        if (metadata != null) {
            return this.annotationArgument.getArgumentMapping().isSetIn(metadata);
        }
        return false;
    }

    @Override
    public boolean isMatcherFor(Object obj) {
        return this.annotationArgument.equals(obj);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.annotationArgument == null ? 0 : this.annotationArgument.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationArgumentResourceMatcher other = (AnnotationArgumentResourceMatcher)obj;
        return !(this.annotationArgument == null ? other.annotationArgument != null : !this.annotationArgument.equals(other.annotationArgument));
    }
}

