/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import java.util.Collection;
import java.util.NoSuchElementException;
import java.util.Set;
import net.sf.extcos.collection.BlacklistAwareIterator;
import net.sf.extcos.collection.BlacklistAwareSet;
import net.sf.extcos.collection.IteratorCreationListener;
import net.sf.extcos.collection.RandomPollingSet;
import net.sf.extcos.exception.StateChangedException;
import net.sf.extcos.internal.ArraySet;
import net.sf.extcos.internal.RandomPollingArraySet;
import net.sf.extcos.util.Assert;

public class BlacklistAwareSetImpl<E>
implements BlacklistAwareSet<E> {
    private final RandomPollingSet<E> backingSet;
    private final Set<E> blacklist;
    private IteratorCreationListener<E> iteratorCreationListener;

    public BlacklistAwareSetImpl(RandomPollingSet<E> backingSet, Set<E> blacklist) {
        Assert.notNull(backingSet, IllegalArgumentException.class);
        Assert.notNull(blacklist, IllegalArgumentException.class);
        backingSet.clear();
        blacklist.clear();
        this.backingSet = backingSet;
        this.blacklist = blacklist;
    }

    @Override
    public BlacklistAwareIterator<E> iterator() {
        RandomPollingArraySet<E> backingSetCopy = new RandomPollingArraySet<E>(this.backingSet);
        ArraySet<E> blacklistCopy = new ArraySet<E>(this.blacklist);
        Itr iterator = new Itr(backingSetCopy, blacklistCopy);
        if (this.iteratorCreationListener != null) {
            this.iteratorCreationListener.created(iterator);
        }
        return iterator;
    }

    @Override
    public int size() {
        return this.backingSet.size();
    }

    @Override
    public boolean addToBlacklist(E entry) {
        if (this.contains(entry)) {
            return this.blacklist.add(entry);
        }
        return false;
    }

    @Override
    public void setIteratorCreationListener(IteratorCreationListener<E> listener) {
        this.iteratorCreationListener = listener;
    }

    @Override
    public boolean add(E element) {
        return this.backingSet.add(element);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.backingSet.addAll(c);
    }

    @Override
    public void clear() {
        this.backingSet.clear();
        this.blacklist.clear();
    }

    @Override
    public boolean contains(Object obj) {
        return this.backingSet.contains(obj);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.backingSet.containsAll(c);
    }

    @Override
    public boolean remove(Object obj) {
        if (this.contains(obj)) {
            this.backingSet.remove(obj);
            this.blacklist.remove(obj);
            return true;
        }
        return false;
    }

    @Override
    public Object[] toArray() {
        return this.backingSet.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.backingSet.toArray(a);
    }

    @Override
    public boolean isEmpty() {
        return this.backingSet.isEmpty();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object obj : c) {
            changed |= this.remove(obj);
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        for (E element : this.backingSet) {
            if (c.contains(element)) continue;
            changed |= this.remove(element);
        }
        return changed;
    }

    @Override
    public void clearBlacklist() {
        this.blacklist.clear();
    }

    @Override
    public boolean isBlacklisted(E element) {
        return this.backingSet.contains(element) && this.blacklist.contains(element);
    }

    @Override
    public boolean removeFromBlacklist(E entry) {
        return this.blacklist.remove(entry);
    }

    private static class Itr<E>
    implements BlacklistAwareIterator<E> {
        private final RandomPollingSet<E> backingSet;
        private final Set<E> blacklist;
        private final Object backingSetMutex = new Object();
        private final Object blacklistMutex = new Object();
        private boolean stateChanged;

        private Itr(RandomPollingSet<E> backingSetSnapshot, Set<E> blacklistSnapshot) {
            this.backingSet = backingSetSnapshot;
            this.blacklist = blacklistSnapshot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = this.blacklistMutex;
            synchronized (object) {
                this.stateChanged = false;
                return this.backingSet.size() > this.blacklist.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            if (this.stateChanged) {
                throw new StateChangedException();
            }
            Object element = null;
            while (element == null && this.backingSet.size() > 0) {
                Object object = this.backingSetMutex;
                synchronized (object) {
                    element = this.backingSet.pollRandom();
                }
                object = this.blacklistMutex;
                synchronized (object) {
                    if (this.blacklist.contains(element)) {
                        this.blacklist.remove(element);
                        element = null;
                    }
                }
            }
            if (element != null) {
                return element;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addToBlacklist(E entry) {
            if (this.eligibleForBlacklisting(entry)) {
                Object object = this.blacklistMutex;
                synchronized (object) {
                    this.blacklist.add(entry);
                    this.stateChanged = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean eligibleForBlacklisting(E entry) {
            Object object = this.backingSetMutex;
            synchronized (object) {
                return this.backingSet.contains(entry);
            }
        }
    }
}

