/*
 * Decompiled with CFR 0.152.
 */
package net.sf.extcos.internal;

import net.sf.extcos.filter.Connector;
import net.sf.extcos.filter.ResultSetProvider;
import net.sf.extcos.internal.AbstractFilterObjectsBuilder;
import net.sf.extcos.internal.BlacklistAwareMultiplexingConnector;
import net.sf.extcos.internal.BlacklistAwareResultSetProvider;
import net.sf.extcos.internal.ExtendingResourceMatcher;
import net.sf.extcos.internal.FilterObjects;
import net.sf.extcos.selector.ExtendingTypeFilter;
import net.sf.extcos.selector.TypeFilter;
import net.sf.extcos.util.Assert;

public class ExtendingFilterObjectsBuilder
extends AbstractFilterObjectsBuilder {
    private final ResultSetProvider provider = new BlacklistAwareResultSetProvider();

    @Override
    public void buildFilterObjects(TypeFilter filter, Connector connector) {
        Assert.notNull(filter, Assert.iae());
        Assert.isTrue(filter instanceof ExtendingTypeFilter, Assert.iae());
        Assert.notNull(connector, Assert.iae());
        ExtendingResourceMatcher matcher = new ExtendingResourceMatcher(((ExtendingTypeFilter)filter).getClazz());
        if (this.buildContext.isRegistered(matcher)) {
            FilterObjects fo = this.buildContext.getFilterObjects(matcher);
            fo.getResourceDispatcher().addConnector(connector);
        } else {
            BlacklistAwareMultiplexingConnector dispatcher = new BlacklistAwareMultiplexingConnector();
            dispatcher.addConnector(connector);
            FilterObjects filterObjects = this.createFilterObjects(dispatcher, matcher, this.provider);
            this.buildContext.register(filter, dispatcher);
            this.buildContext.register(filterObjects);
        }
    }
}

